/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.instructions;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.balayage.BalayageTemplate;
import fr.exemole.bdfserver.api.balayage.TemplateProvider;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.get.streamproducers.ExtractionXmlProducer;
import fr.exemole.bdfserver.tools.balayage.BdfBalayageUtils;
import fr.exemole.bdfserver.tools.balayage.TemplateProviderBuilder;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageParameters;
import fr.exemole.bdfserver.tools.balayage.engine.EngineUtils;
import fr.exemole.bdfserver.tools.configuration.PathConfigurationBuilder;
import fr.exemole.bdfserver.tools.instruction.DefaultBdfParameters;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.exportation.balayage.BalayageDef;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.exportation.balayage.BalayageOutput;
import net.fichotheque.exportation.balayage.BalayageUnit;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.ExtractionSource;
import net.fichotheque.extraction.def.ExtractionDef;
import net.fichotheque.tools.extraction.ExtractionEngine;
import net.fichotheque.tools.extraction.ExtractionEngineUtils;
import net.mapeadores.util.exceptions.NestedSAXException;
import net.mapeadores.util.io.BufferErrorListener;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.exceptions.InternalErrorException;
import net.mapeadores.util.servlets.handlers.StreamResponseHandler;
import net.mapeadores.util.servlets.handlers.XmlResponseHandler;
import net.mapeadores.util.text.ValueResolver;
import org.xml.sax.SAXException;

public class BalayagesInstruction
implements BdfInstruction {
    private final BdfServer bdfServer;
    private final String filePath;

    public BalayagesInstruction(BdfServer bdfServer, String filePath) {
        this.bdfServer = bdfServer;
        this.filePath = filePath;
    }

    @Override
    public short getBdfUserNeed() {
        return 3;
    }

    @Override
    public ResponseHandler runInstruction(BdfUser bdfUser) {
        DefaultBdfParameters bdfParameters = new DefaultBdfParameters(this.bdfServer, bdfUser);
        BalayageUnitInitializer balayageUnitInitializer = new BalayageUnitInitializer(this.bdfServer);
        boolean done = balayageUnitInitializer.initFilePath(this.filePath);
        if (!done) {
            return null;
        }
        try {
            balayageUnitInitializer.initExtraction();
        }
        catch (SAXException saxe) {
            throw new NestedSAXException(saxe);
        }
        BalayageParameters balayageParameters = balayageUnitInitializer.getBalayageParameters();
        ExtractParameters extractParameters = balayageParameters.getExtractParameters();
        ExtractionDef extractionDef = balayageUnitInitializer.getExtractionDef();
        Object dynamicObject = balayageUnitInitializer.getDynamicObject();
        ExtractionSource extractionSource = ExtractionEngineUtils.getExtractionSource(dynamicObject, extractParameters.getExtractionContext(), extractionDef, balayageParameters.getSelectedFiches());
        if (balayageUnitInitializer.isXmlVersion()) {
            ExtractionXmlProducer xmlProducer = new ExtractionXmlProducer(extractParameters, extractionDef, extractionSource, null);
            return XmlResponseHandler.init(xmlProducer);
        }
        if (balayageUnitInitializer.hasError()) {
            throw new InternalErrorException("_ error.exception.internalerror", balayageUnitInitializer.getErrorKey());
        }
        TemplateProvider templateProvider = balayageUnitInitializer.getTemplateProvider();
        String extractionString = ExtractionEngine.init(extractParameters, extractionDef).run(extractionSource);
        return StreamResponseHandler.init(new BalayageTemplateStreamProducer(null, templateProvider.getBalayageTemplate(dynamicObject), extractionString));
    }

    private static class BalayageUnitInitializer {
        private final BdfServer bdfServer;
        private final PathConfiguration pathConfiguration;
        private BalayageDescription balayageDescription;
        private BalayageDef balayageDef;
        private BalayageUnit balayageUnit;
        private SubsetKey subsetKey;
        private Subset subset;
        private SubsetItem subsetItem;
        private Lang lang;
        private boolean xmlVersion;
        private BalayageParameters balayageParameters;
        private ExtractionDef extractionDef;
        private Object dynamicObject;
        private String errorKey = null;
        private TemplateProvider templateProvider;
        private BalayageOutput output;

        private BalayageUnitInitializer(BdfServer bdfServer) {
            this.bdfServer = bdfServer;
            this.pathConfiguration = PathConfigurationBuilder.build(bdfServer);
        }

        public boolean isXmlVersion() {
            return this.xmlVersion;
        }

        public BalayageParameters getBalayageParameters() {
            return this.balayageParameters;
        }

        public ExtractionDef getExtractionDef() {
            return this.extractionDef;
        }

        public Object getDynamicObject() {
            return this.dynamicObject;
        }

        public TemplateProvider getTemplateProvider() {
            return this.templateProvider;
        }

        public boolean hasError() {
            return this.errorKey != null;
        }

        public String getErrorKey() {
            return this.errorKey;
        }

        public boolean initFilePath(String filePath) {
            int ln = filePath.length();
            int idx1 = filePath.indexOf(47);
            if (idx1 == -1) {
                return false;
            }
            int idx2 = filePath.indexOf(47, idx1 + 1);
            if (idx2 == -1 || idx2 > ln - 5) {
                return false;
            }
            String balayageName = filePath.substring(0, idx1);
            boolean test = this.initBalayage(balayageName);
            if (!test) {
                return false;
            }
            String balayageUnitName = filePath.substring(idx1 + 1, idx2);
            test = this.initBalayageUnit(balayageUnitName);
            if (!test) {
                return false;
            }
            String baseName = filePath.substring(idx2 + 1);
            test = this.initSubset(baseName);
            return test;
        }

        private void initExtraction() throws SAXException {
            this.balayageParameters = new BalayageParameters(this.balayageDescription, this.bdfServer, PathConfigurationBuilder.build(this.bdfServer));
            ExtractParameters extractParameters = this.balayageParameters.getExtractParameters();
            if (this.lang == null) {
                this.lang = extractParameters.getExtractionContext().getLangContext().getDefaultLang();
            }
            String balayageType = this.balayageUnit.getType();
            String extractionPath = this.balayageUnit.getExtractionPath();
            this.extractionDef = !extractionPath.isEmpty() ? BdfBalayageUtils.getExtractionDef(this.bdfServer, this.balayageDescription, extractionPath) : BdfBalayageUtils.getDefaultExtractionDef(balayageType);
            if (this.dynamicObject == null) {
                this.dynamicObject = this.subset;
            }
            if (!this.xmlVersion) {
                if (this.balayageDef.ignoreTransformation()) {
                    this.xmlVersion = true;
                } else {
                    BalayageOutput checkedOutput = this.checkOutput();
                    if (checkedOutput == null) {
                        this.xmlVersion = true;
                    } else {
                        this.initTemplateProvider(checkedOutput, this.lang.toString());
                    }
                }
            }
        }

        private void initTemplateProvider(BalayageOutput output, String lang) {
            InternalTemplateProviderBuilderErrorHandler transformerBuilderErrorHandler = new InternalTemplateProviderBuilderErrorHandler();
            TemplateProviderBuilder templateProviderBuilder = new TemplateProviderBuilder(this.bdfServer, this.pathConfiguration, this.balayageDef, transformerBuilderErrorHandler);
            this.templateProvider = templateProviderBuilder.build(output);
            if (this.templateProvider != null) {
                ValueResolver patternValueSet = EngineUtils.getValueResolver(this.dynamicObject);
                String path = EngineUtils.getPath(output, patternValueSet);
                String fileName = EngineUtils.getFileName(output, patternValueSet, this.balayageUnit.getType(), true);
                this.templateProvider.setCurrentFileName(fileName);
                this.templateProvider.setCurrentPath(path);
                this.templateProvider.setCurrentLang(lang);
            }
        }

        private boolean initBalayage(String balayageName) {
            int idxtiret = balayageName.indexOf(45);
            if (idxtiret != -1) {
                try {
                    this.lang = Lang.parse(balayageName.substring(idxtiret + 1));
                }
                catch (ParseException pe) {
                    return false;
                }
                balayageName = balayageName.substring(0, idxtiret);
            }
            this.balayageDescription = this.bdfServer.getBalayageManager().getBalayage(balayageName);
            if (this.balayageDescription != null) {
                this.balayageDef = this.balayageDescription.getBalayageDef();
            }
            return this.balayageDescription != null;
        }

        private boolean initBalayageUnit(String balayageUnitName) {
            int idxtiret = balayageUnitName.indexOf(45);
            String outputName = null;
            if (idxtiret != -1) {
                if (idxtiret < 2) {
                    return false;
                }
                outputName = balayageUnitName.substring(idxtiret + 1);
                balayageUnitName = balayageUnitName.substring(0, idxtiret);
            }
            this.balayageUnit = this.balayageDef.getBalayageUnit(balayageUnitName);
            if (this.balayageUnit == null) {
                return false;
            }
            if (outputName != null) {
                this.output = this.balayageUnit.getOutput(outputName);
                if (this.output == null) {
                    return false;
                }
            }
            return true;
        }

        private boolean initSubset(String baseName) {
            if (baseName.endsWith(".xml")) {
                this.xmlVersion = true;
                baseName = baseName.substring(0, baseName.length() - 4);
            }
            int idxtiret = baseName.indexOf(45);
            boolean needId = false;
            try {
                switch (this.balayageUnit.getType()) {
                    case "unique": {
                        return baseName.equals("unique");
                    }
                    case "corpus": {
                        if (idxtiret != -1) {
                            return false;
                        }
                        this.subsetKey = SubsetKey.parse((short)1, baseName);
                        break;
                    }
                    case "thesaurus": {
                        if (idxtiret != -1) {
                            return false;
                        }
                        this.subsetKey = SubsetKey.parse((short)2, baseName);
                        break;
                    }
                    case "fiche": {
                        if (idxtiret < 2) {
                            return false;
                        }
                        this.subsetKey = SubsetKey.parse((short)1, baseName.substring(0, idxtiret));
                        needId = true;
                        break;
                    }
                    case "motcle": {
                        if (idxtiret < 2) {
                            return false;
                        }
                        this.subsetKey = SubsetKey.parse((short)2, baseName.substring(0, idxtiret));
                        needId = true;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            catch (ParseException pe) {
                return false;
            }
            this.subset = this.bdfServer.getFichotheque().getSubset(this.subsetKey);
            if (this.subset == null) {
                return false;
            }
            if (needId) {
                try {
                    int subsetItemId = Integer.parseInt(baseName.substring(idxtiret + 1));
                    if (subsetItemId < 1) {
                        return false;
                    }
                    this.subsetItem = this.subset.getSubsetItemById(subsetItemId);
                    if (this.subsetItem == null) {
                        return false;
                    }
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
            return true;
        }

        private BalayageOutput checkOutput() {
            if (this.output != null) {
                return this.output;
            }
            List<BalayageOutput> outputList = this.balayageUnit.getOutputList();
            if (outputList.isEmpty()) {
                return null;
            }
            return outputList.get(0);
        }

        private class InternalTemplateProviderBuilderErrorHandler
        implements TemplateProviderBuilder.ErrorHandler {
            private InternalTemplateProviderBuilderErrorHandler() {
            }

            @Override
            public void transformerError(String xsltPath, BufferErrorListener errorListener) {
                BalayageUnitInitializer.this.errorKey = "XSLT error : " + errorListener.getErrorMessage();
            }

            @Override
            public void wrongXslPath(String xsltPath) {
                BalayageUnitInitializer.this.errorKey = "wrong xslt path : " + xsltPath;
            }

            @Override
            public void undefinedXslPath() {
                BalayageUnitInitializer.this.errorKey = "xslt attribute of output element is not defined";
            }

            @Override
            public void wrongBalayageUnitType() {
            }
        }
    }

    private static class BalayageTemplateStreamProducer
    implements StreamProducer {
        private final String fileName;
        private final BalayageTemplate balayageTemplate;
        private final String extractionString;

        private BalayageTemplateStreamProducer(String fileName, BalayageTemplate balayageTemplate, String extractionString) {
            this.fileName = fileName;
            this.balayageTemplate = balayageTemplate;
            this.extractionString = extractionString;
        }

        @Override
        public String getMimeType() {
            return this.balayageTemplate.getMimeType();
        }

        @Override
        public String getCharset() {
            return this.balayageTemplate.getCharset();
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public void writeStream(OutputStream outputStream) throws IOException {
            this.balayageTemplate.transform(this.extractionString, outputStream);
        }
    }
}

