/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.email;

import java.util.ArrayList;
import java.util.List;

public class SendReport {
    public static final short OK_STATE = 1;
    public static final short EMAILBUILD_ERROR_STATE = -1;
    public static final short SEND_ERROR_STATE = -2;
    private final short state;
    private final List<String> attachmentList = new ArrayList<String>();
    private final String errorMessage;

    private SendReport(short state) {
        this.state = state;
        this.errorMessage = null;
    }

    private SendReport(short state, String errorMessage) {
        this.state = state;
        this.errorMessage = errorMessage;
    }

    public static SendReport okReport() {
        return new SendReport(1);
    }

    public static SendReport sendErrorReport(String errorMessage) {
        return new SendReport(-2, errorMessage);
    }

    public static SendReport emailBuildErrorReport(String errorMessage) {
        return new SendReport(-1, errorMessage);
    }

    public short getState() {
        return this.state;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void addAttachment(String fileName) {
        this.attachmentList.add(fileName);
    }

    public List<String> getAttachmentList() {
        return this.attachmentList;
    }
}

