/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.email;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.email.EmailBuffer;
import fr.exemole.bdfserver.email.FicheAttachmentParameters;
import fr.exemole.bdfserver.email.SendReport;
import fr.exemole.bdfserver.email.SmtpManager;
import fr.exemole.bdfserver.email.TableExportEmail;
import fr.exemole.bdfserver.email.datasource.SimpleTemplateDataSource;
import fr.exemole.bdfserver.email.datasource.StreamDataSourceFactory;
import fr.exemole.bdfserver.email.datasource.TableExportDataSource;
import fr.exemole.bdfserver.email.datasource.VersionDataSource;
import java.util.List;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.fichotheque.SubsetItem;
import net.fichotheque.addenda.Version;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.utils.CorpusUtils;
import net.mapeadores.util.email.EmailUtils;
import net.mapeadores.util.text.ValidExtension;

public class SendEngine {
    private final SmtpManager smtpManager;
    private final BdfParameters bdfParameters;

    public SendEngine(SmtpManager smtpManager, BdfParameters bdfParameters) {
        this.smtpManager = smtpManager;
        this.bdfParameters = bdfParameters;
    }

    public SendReport sendEmail(EmailBuffer emailBuffer) {
        SendReport okReport;
        Session session = EmailUtils.createSession(this.smtpManager.getSmtpParameters());
        MimeMessage message = new MimeMessage(session);
        try {
            ConversionEngine conversionEngine = new ConversionEngine(emailBuffer, message);
            okReport = conversionEngine.run();
        }
        catch (MessagingException e) {
            return SendReport.emailBuildErrorReport(e.getMessage());
        }
        try {
            Transport.send((Message)message);
            return okReport;
        }
        catch (MessagingException e) {
            return SendReport.sendErrorReport(e.getMessage());
        }
    }

    public static SendEngine build(BdfParameters bdfParameters) {
        return new SendEngine((SmtpManager)bdfParameters.getBdfServer().getContextObject("smtpManager"), bdfParameters);
    }

    public static boolean canSend(BdfParameters bdfParameters) {
        SmtpManager smtpManager = (SmtpManager)bdfParameters.getBdfServer().getContextObject("smtpManager");
        if (!smtpManager.isInit()) {
            return false;
        }
        return bdfParameters.getBdfUser().getRedacteur().getEmailCore() != null;
    }

    private static void escape(char carac, StringBuilder buf) {
        switch (carac) {
            case '&': {
                buf.append("&amp;");
                break;
            }
            case '\"': {
                buf.append("&quot;");
                break;
            }
            case '<': {
                buf.append("&lt;");
                break;
            }
            case '>': {
                buf.append("&gt;");
                break;
            }
            case '\'': {
                buf.append("&#x27;");
                break;
            }
            case '\\': {
                buf.append("&#x5C;");
                break;
            }
            case '`': {
                buf.append("&#x60;");
                break;
            }
            default: {
                buf.append(carac);
            }
        }
    }

    private class ConversionEngine {
        private final MimeMessage mimeMessage;
        private final EmailBuffer emailBuffer;
        private final SendReport okReport;
        private final Multipart root;

        private ConversionEngine(EmailBuffer emailBuffer, MimeMessage mimeMessage) {
            this.mimeMessage = mimeMessage;
            this.emailBuffer = emailBuffer;
            this.okReport = SendReport.okReport();
            this.root = new MimeMultipart();
        }

        private SendReport run() throws MessagingException {
            this.convertHeaders();
            switch (this.emailBuffer.getSendType()) {
                case "fiche": {
                    this.convertFiche();
                    break;
                }
                case "compilation": {
                    this.convertCompilation();
                    break;
                }
                case "tableexport": {
                    this.convertTableExport();
                    break;
                }
                case "selection": {
                    this.convertSelection();
                    break;
                }
                default: {
                    this.insertMessage();
                }
            }
            this.mimeMessage.setContent(this.root);
            return this.okReport;
        }

        private void convertHeaders() throws MessagingException {
            this.mimeMessage.setFrom((Address)EmailUtils.convert(this.emailBuffer.getFromEmail()));
            this.mimeMessage.setReplyTo((Address[])EmailUtils.convert(this.emailBuffer.getReplytoCollection()));
            this.mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])EmailUtils.convert(this.emailBuffer.getToCollection()));
            this.mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])EmailUtils.convert(this.emailBuffer.getCcCollection()));
            this.mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])EmailUtils.convert(this.emailBuffer.getBccCollection()));
            this.mimeMessage.setSubject(this.emailBuffer.getSubject(), "utf-8");
        }

        private void convertFiche() throws MessagingException {
            FicheMeta ficheMeta = (FicheMeta)this.emailBuffer.getSendObject();
            FicheAttachmentParameters ficheAttachmentParameters = this.emailBuffer.getFicheAttachmentParameters();
            this.insertMessage();
            if (ficheAttachmentParameters.isWithHtml()) {
                SimpleTemplateDataSource simpleTemplateDataSource = SimpleTemplateDataSource.newFicheInstance(SendEngine.this.bdfParameters, ficheMeta, ficheAttachmentParameters.getHtmlTemplateName());
                this.insert(simpleTemplateDataSource);
            }
            if (ficheAttachmentParameters.isWithOdt()) {
                this.attach(StreamDataSourceFactory.newFicheInstance(SendEngine.this.bdfParameters, ficheMeta, ValidExtension.ODT, ficheAttachmentParameters.getOdtTemplateName()));
            }
            for (Version version : ficheAttachmentParameters.getVersionCollection()) {
                this.attach(VersionDataSource.newInstance(SendEngine.this.bdfParameters.getBdfServer(), version));
            }
        }

        private void convertCompilation() throws MessagingException {
            BdfUser bdfUser = SendEngine.this.bdfParameters.getBdfUser();
            FicheAttachmentParameters ficheAttachmentParameters = this.emailBuffer.getFicheAttachmentParameters();
            this.insertMessage();
            if (ficheAttachmentParameters.isWithHtml()) {
                SimpleTemplateDataSource simpleTemplateDataSource = SimpleTemplateDataSource.newCompilationInstance(SendEngine.this.bdfParameters, bdfUser.getSelectedFiches(), ficheAttachmentParameters.getHtmlTemplateName());
                this.insert(simpleTemplateDataSource);
                this.attach(simpleTemplateDataSource);
            }
            if (ficheAttachmentParameters.isWithOdt()) {
                this.attach(StreamDataSourceFactory.newCompilationInstance(SendEngine.this.bdfParameters, bdfUser.getSelectedFiches(), ValidExtension.ODT, ficheAttachmentParameters.getOdtTemplateName()));
            }
        }

        private void convertSelection() throws MessagingException {
            FicheAttachmentParameters ficheAttachmentParameters = this.emailBuffer.getFicheAttachmentParameters();
            Set ficheMetaSet = (Set)this.emailBuffer.getSendObject();
            this.insertMessage();
            for (FicheMeta ficheMeta : ficheMetaSet) {
                if (ficheAttachmentParameters.isWithHtml()) {
                    SimpleTemplateDataSource simpleTemplateDataSource = SimpleTemplateDataSource.newFicheInstance(SendEngine.this.bdfParameters, ficheMeta, ficheAttachmentParameters.getHtmlTemplateName());
                    this.insert(simpleTemplateDataSource);
                    this.attach(simpleTemplateDataSource);
                }
                if (!ficheAttachmentParameters.isWithOdt()) continue;
                this.attach(StreamDataSourceFactory.newFicheInstance(SendEngine.this.bdfParameters, ficheMeta, ValidExtension.ODT, ficheAttachmentParameters.getOdtTemplateName()));
            }
        }

        private void convertTableExport() throws MessagingException {
            TableExportEmail tableExportEmail = (TableExportEmail)this.emailBuffer.getSendObject();
            Corpus corpus = tableExportEmail.getCorpus();
            if (!SendEngine.this.bdfParameters.getPermissionSummary().hasAccess(corpus)) {
                return;
            }
            List<SubsetItem> subsetItemList = CorpusUtils.getFicheMetaListByCorpus(SendEngine.this.bdfParameters.getBdfUser().getSelectedFiches(), corpus.getSubsetKey());
            TableExportDataSource tableExportDataSource = TableExportDataSource.build(SendEngine.this.bdfParameters, corpus, subsetItemList, tableExportEmail.getTableExportParameters(), tableExportEmail.getExtension(), tableExportEmail.getCharset());
            this.insertMessage();
            this.attach(tableExportDataSource);
        }

        private void insertMessage() throws MessagingException {
            this.insertMessage(this.root);
        }

        private void insertMessage(Multipart mp) throws MessagingException {
            MimeBodyPart part = new MimeBodyPart();
            part.setText(this.emailBuffer.getMessage(), "utf-8");
            mp.addBodyPart((BodyPart)part);
        }

        private void insert(SimpleTemplateDataSource simpleTemplateDataSource) throws MessagingException {
            if (simpleTemplateDataSource.getMimeType().equals("text/html")) {
                MimeBodyPart htmlPart = new MimeBodyPart();
                htmlPart.setText(simpleTemplateDataSource.getContent(), "utf-8", "html");
                this.root.addBodyPart((BodyPart)htmlPart);
            }
        }

        private void insertVariante(SimpleTemplateDataSource simpleTemplateDataSource) throws MessagingException {
            if (simpleTemplateDataSource.getMimeType().equals("text/html")) {
                MimeMultipart alternative = new MimeMultipart("alternative");
                this.insertMessage((Multipart)alternative);
                this.mergeMessageInHtml((Multipart)alternative, simpleTemplateDataSource.getContent());
                this.addSubMultipart((Multipart)alternative, this.root);
            } else {
                this.insertMessage();
            }
            this.attach(simpleTemplateDataSource);
        }

        private void mergeMessageInHtml(Multipart mp, String html) throws MessagingException {
            int idx = html.indexOf("<body");
            if (idx != -1) {
                idx = html.indexOf(62, idx + 1);
            }
            html = idx != -1 ? html.substring(0, idx + 1) + this.getPre() + html.substring(idx + 1) : this.getPre() + html;
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setText(html, "utf-8", "html");
            mp.addBodyPart((BodyPart)htmlPart);
        }

        private void addSubMultipart(Multipart sub, Multipart parent) throws MessagingException {
            MimeBodyPart part = new MimeBodyPart();
            part.setContent(sub);
            parent.addBodyPart((BodyPart)part);
        }

        private void attach(DataSource dataSource) throws MessagingException {
            this.okReport.addAttachment(dataSource.getName());
            MimeBodyPart part = new MimeBodyPart();
            part.setDisposition("attachment");
            part.setFileName(dataSource.getName());
            part.setDataHandler(new DataHandler(dataSource));
            this.root.addBodyPart((BodyPart)part);
        }

        private String getPre() {
            String text = this.emailBuffer.getMessage();
            StringBuilder buf = new StringBuilder();
            buf.append("<pre>");
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                SendEngine.escape(text.charAt(i), buf);
            }
            buf.append("</pre><br>");
            return buf.toString();
        }
    }
}

