/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.NoRemoveableSubsetException;
import net.fichotheque.SubsetKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ThesaurusRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ThesaurusRemove";
    public static final String COMMANDKEY = "_ THS-04";
    private Thesaurus thesaurus;

    public ThesaurusRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        SubsetKey thesaurusKey = this.thesaurus.getSubsetKey();
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            try {
                session.getFichothequeEditor().removeThesaurus(this.thesaurus);
            }
            catch (NoRemoveableSubsetException nrse) {
                throw new ShouldNotOccurException("test done before");
            }
        }
        this.putResultObject("obj.subsetkey", thesaurusKey);
        this.setDone("_ done.thesaurus.thesaurusremove", thesaurusKey.getSubsetName());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.thesaurus = this.requestHandler.getMandatoryThesaurus();
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
        if (!this.thesaurus.isRemoveable()) {
            throw BdfErrors.error("_ error.notremoveable.thesaurus");
        }
    }
}

