/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.ScrutariExportManager;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.exportation.scrutari.ScrutariExportDef;
import net.fichotheque.metadata.FichothequeMetadata;
import net.fichotheque.tools.exportation.scrutari.ScrutariExportDefBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ScrutariExportCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ScrutariExportCreation";
    public static final String COMMANDKEY = "_ EXP-21";
    public static final String NEWSCRUTARIEXPORT_PARAMNAME = "newscrutariexport";
    private String newScrutariExportName;

    public ScrutariExportCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        ScrutariExportManager scrutariExportManager = this.bdfServer.getScrutariExportManager();
        FichothequeMetadata fichothequeMetadata = this.fichotheque.getFichothequeMetadata();
        ScrutariExportDef scrutariExportDef = ScrutariExportDefBuilder.init(this.newScrutariExportName, fichothequeMetadata.getAuthority(), fichothequeMetadata.getBaseName()).toScrutariExportDef();
        scrutariExportManager.putScrutariExportDef(scrutariExportDef);
        this.putResultObject("obj.scrutariexportdef", scrutariExportDef);
        this.setDone("_ done.exportation.scrutariexportcreation", this.newScrutariExportName);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.newScrutariExportName = this.getMandatory(NEWSCRUTARIEXPORT_PARAMNAME).trim();
        if (this.newScrutariExportName.length() == 0) {
            throw BdfErrors.error("_ error.empty.exportname");
        }
        ScrutariExportDef scrutariExportDef = this.bdfServer.getScrutariExportManager().getScrutariExportDef(this.newScrutariExportName);
        if (scrutariExportDef != null) {
            throw BdfErrors.error("_ error.existing.scrutariexport", this.newScrutariExportName);
        }
        try {
            ScrutariExportDef.checkScrutariExportName(this.newScrutariExportName);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.exportname", this.newScrutariExportName);
        }
    }
}

