/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique.recap;

import fr.exemole.bdfext.scarabe.api.analytique.AgregatDef;
import fr.exemole.bdfext.scarabe.api.analytique.AgregatGathering;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueGathering;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueItem;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueItemEligibility;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueParameters;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueRecap;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueSubset;
import fr.exemole.bdfext.scarabe.api.analytique.OperationDef;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.ConversionEngineParameters;
import fr.exemole.bdfext.scarabe.tools.analytique.EngineParameters;
import fr.exemole.bdfext.scarabe.tools.analytique.NaturalEngineParameters;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.AgregatBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.AnalytiqueRecapBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.ConversionRecapEngine;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.NaturalRecapEngine;
import fr.exemole.bdfext.scarabe.tools.core.CoreUtils;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.fichotheque.corpus.FicheMeta;
import net.mapeadores.util.date.RangeDateFilter;
import net.mapeadores.util.money.Currencies;

public abstract class RecapEngine {
    private AnalytiqueParameters analytiqueParameters;
    private Currencies currencies;
    private RangeDateFilter dateFilter;
    private Predicate<FicheMeta> fichePredicate;
    private OperationDef[] operationDefArray;

    protected RecapEngine() {
    }

    protected void setCustomCurrencies(Currencies currencies) {
        this.currencies = currencies;
    }

    public abstract void addAgregat(AgregatBuilder var1, AgregatGathering var2);

    public abstract void addApport(AnalytiqueRecapBuilder var1, Ligne var2);

    public abstract void addAvanceNonSoldee(AnalytiqueRecapBuilder var1, Ligne var2);

    public abstract void addDepense(AnalytiqueRecapBuilder var1, Ligne var2);

    public abstract void addDepenseAvenir(AnalytiqueRecapBuilder var1, Avenir var2);

    public AnalytiqueRecap buildFromRoot() {
        AnalytiqueSubset analytiqueSubset = this.analytiqueParameters.getAnalytiqueSubset();
        AnalytiqueItemEligibility rootEligibility = AnalytiqueUtils.buildAnalytiqueItemEligibility(this.analytiqueParameters);
        AnalytiqueRecapBuilder builder = this.newRootBuilder();
        for (AnalytiqueItem analytiqueItem : analytiqueSubset.getFirstLevelList()) {
            AnalytiqueRecap subRecap;
            AnalytiqueItemEligibility childEligibility;
            boolean selfInclude;
            short test = rootEligibility.accept(analytiqueItem);
            if (test == 1) continue;
            if (test == 3) {
                selfInclude = true;
                childEligibility = rootEligibility.getChildrenDerivation();
            } else {
                selfInclude = false;
                childEligibility = rootEligibility;
            }
            if ((subRecap = this.buildFromAnalytiqueItem(analytiqueItem, childEligibility, selfInclude)) == null) continue;
            builder.addSubRecap(subRecap);
        }
        return builder.toAnalytiqueRecap();
    }

    public AnalytiqueRecap buildFromAnalytiqueItem(AnalytiqueItem analytiqueItem) {
        AnalytiqueItemEligibility childEligibility;
        boolean selfInclude;
        AnalytiqueItemEligibility rootEligibility = AnalytiqueUtils.buildAnalytiqueItemEligibility(this.analytiqueParameters);
        int use = AnalytiqueUtils.useOwnLignes(this.analytiqueParameters.getAnalytiqueSubset(), analytiqueItem, rootEligibility);
        if (use == -1) {
            return null;
        }
        if (use == 1) {
            selfInclude = true;
            childEligibility = rootEligibility.getChildrenDerivation();
        } else {
            selfInclude = false;
            childEligibility = rootEligibility;
        }
        return this.buildFromAnalytiqueItem(analytiqueItem, childEligibility, selfInclude);
    }

    private AnalytiqueRecap buildFromAnalytiqueItem(AnalytiqueItem analytiqueItem, AnalytiqueItemEligibility currentEligibility, boolean selfInclude) {
        ArrayList<AnalytiqueRecap> subList = new ArrayList<AnalytiqueRecap>();
        for (AnalytiqueItem child : analytiqueItem.getChildList()) {
            AnalytiqueRecap subRecap;
            AnalytiqueItemEligibility childrenEligibility;
            boolean subRecapInclude;
            short test = currentEligibility.accept(child);
            if (test == 1) continue;
            if (test == 3) {
                subRecapInclude = true;
                childrenEligibility = currentEligibility.getChildrenDerivation();
            } else {
                subRecapInclude = false;
                childrenEligibility = currentEligibility;
            }
            if ((subRecap = this.buildFromAnalytiqueItem(child, childrenEligibility, subRecapInclude)) == null) continue;
            subList.add(subRecap);
        }
        if (!selfInclude && subList.isEmpty()) {
            return null;
        }
        AnalytiqueRecapBuilder builder = this.newBuilder(analytiqueItem);
        if (selfInclude) {
            for (AnalytiqueGathering.SubCorpus subCorpus : analytiqueItem.getSubCorpusList()) {
                builder.addSubRecap(this.toAnalytiqueRecap(subCorpus));
            }
            for (AnalytiqueGathering.Groupby groupby : analytiqueItem.getGroupbyList()) {
                builder.addSubRecap(this.toAnalytiqueRecap(groupby));
            }
        }
        for (AnalytiqueRecap analytiqueRecap : subList) {
            builder.addSubRecap(analytiqueRecap);
        }
        if (selfInclude) {
            this.populate(builder, analytiqueItem);
        }
        return builder.toAnalytiqueRecap();
    }

    private AnalytiqueRecapBuilder newBuilder(Object recapObject) {
        return new AnalytiqueRecapBuilder(recapObject, this.analytiqueParameters, this.currencies, this.operationDefArray);
    }

    private AnalytiqueRecapBuilder newRootBuilder() {
        return new AnalytiqueRecapBuilder(Boolean.FALSE, this.analytiqueParameters, this.currencies, this.operationDefArray);
    }

    private AnalytiqueRecap toAnalytiqueRecap(AnalytiqueGathering.Groupby groupby) {
        AnalytiqueRecapBuilder builder = this.newBuilder(groupby);
        for (AnalytiqueGathering.Groupby child : groupby.getChildList()) {
            builder.addSubRecap(this.toAnalytiqueRecap(child));
        }
        this.populate(builder, groupby);
        return builder.toAnalytiqueRecap();
    }

    private AnalytiqueRecap toAnalytiqueRecap(AnalytiqueGathering ligneGathering) {
        AnalytiqueRecapBuilder builder = this.newBuilder(ligneGathering);
        this.populate(builder, ligneGathering);
        return builder.toAnalytiqueRecap();
    }

    private void populate(AnalytiqueRecapBuilder builder, AnalytiqueGathering ligneGathering) {
        int operationDefLength = this.operationDefArray.length;
        for (int i = 0; i < operationDefLength; ++i) {
            OperationDef operationDef = this.operationDefArray[i];
            if (!(operationDef instanceof AgregatDef)) continue;
            this.addAgregat(builder.getAgregatBuilder(i), ligneGathering.getAgregatGathering(i));
        }
        for (Ligne ligne : ligneGathering.getApportList()) {
            if (!RecapEngine.testLigne(ligne, this.dateFilter, this.fichePredicate)) continue;
            this.addApport(builder, ligne);
        }
        for (Ligne ligne : ligneGathering.getDepenseList()) {
            if (!RecapEngine.testLigne(ligne, this.dateFilter, this.fichePredicate)) continue;
            this.addDepense(builder, ligne);
        }
        for (Ligne ligne : ligneGathering.getAvanceList()) {
            if (!RecapEngine.testLigne(ligne, this.dateFilter, this.fichePredicate) || !CoreUtils.isAvanceNonSoldee(ligne)) continue;
            this.addAvanceNonSoldee(builder, ligne);
        }
        for (Avenir avenir : ligneGathering.getDepenseAvenirList()) {
            if (!RecapEngine.testAvenir(avenir, this.dateFilter, this.fichePredicate)) continue;
            this.addDepenseAvenir(builder, avenir);
        }
    }

    public static RecapEngine newRecapEngine(EngineParameters engineParameters, AnalytiqueParameters analytiqueParameters, RangeDateFilter dateFilter, Predicate<FicheMeta> fichePredicate, OperationDef[] operationDefArray) {
        RecapEngine recapEngine;
        if (engineParameters instanceof NaturalEngineParameters) {
            recapEngine = new NaturalRecapEngine((NaturalEngineParameters)engineParameters);
        } else if (engineParameters instanceof ConversionEngineParameters) {
            recapEngine = new ConversionRecapEngine((ConversionEngineParameters)engineParameters);
        } else {
            throw new IllegalArgumentException("Unknown class: " + engineParameters.getClass().getName());
        }
        recapEngine.dateFilter = dateFilter;
        recapEngine.fichePredicate = fichePredicate;
        recapEngine.operationDefArray = operationDefArray;
        recapEngine.analytiqueParameters = analytiqueParameters;
        return recapEngine;
    }

    private static boolean testLigne(Ligne ligne, RangeDateFilter dateFilter, Predicate<FicheMeta> fichePredicate) {
        if (dateFilter != null && dateFilter.testInRange(ligne.getDate()) == 1) {
            return false;
        }
        return fichePredicate == null || fichePredicate.test(ligne.getFicheMeta());
    }

    private static boolean testAvenir(Avenir avenir, RangeDateFilter dateFilter, Predicate<FicheMeta> fichePredicate) {
        if (dateFilter != null && dateFilter.testInRange(avenir.getDatePrevue()) == 1) {
            return false;
        }
        return fichePredicate == null || fichePredicate.test(avenir.getFicheMeta());
    }
}

