/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique.recap;

import fr.exemole.bdfext.scarabe.api.analytique.AgregatGathering;
import fr.exemole.bdfext.scarabe.api.analytique.AgregatUnit;
import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.cours.CoursManager;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.ConversionEngineParameters;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.AgregatBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.AnalytiqueRecapBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.RecapEngine;
import net.fichotheque.SubsetItem;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.CurrenciesUtils;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyConversion;

class ConversionRecapEngine
extends RecapEngine {
    private final Currencies currencies;
    private final ExtendedCurrency pivotCurrency;
    private final CoursManager coursManager;

    ConversionRecapEngine(ConversionEngineParameters conversionEngineParameters) {
        this.coursManager = conversionEngineParameters.getCoursManager();
        this.pivotCurrency = conversionEngineParameters.getPivotCurrency();
        this.currencies = conversionEngineParameters.getCurrencies();
        this.setCustomCurrencies(CurrenciesUtils.wrap((ExtendedCurrency[])new ExtendedCurrency[]{this.pivotCurrency}));
    }

    @Override
    public void addAgregat(AgregatBuilder agregatBuilder, AgregatGathering agregatGathering) {
        MoneyByCurrency moneyByCurrency = agregatGathering.getMoneyByCurrency();
        if (moneyByCurrency.isEmpty()) {
            return;
        }
        this.convert(moneyByCurrency, agregatBuilder, null);
        for (AgregatUnit agregatUnit : agregatGathering.getUnitList()) {
            this.convert(agregatUnit.getMoneyByCurrency(), agregatBuilder, agregatUnit.getSubsetItem());
        }
    }

    private void convert(MoneyByCurrency moneyByCurrency, AgregatBuilder agregatBuilder, SubsetItem subsetItem) {
        int currencyLength = this.currencies.size();
        for (int i = 0; i < currencyLength; ++i) {
            if (!moneyByCurrency.withMoney(i)) continue;
            ExtendedCurrency currency = (ExtendedCurrency)this.currencies.get(i);
            if (currency.equals((Object)this.pivotCurrency)) {
                long moneyLong = moneyByCurrency.getMoneyLong(i);
                if (subsetItem != null) {
                    agregatBuilder.add(subsetItem, 0, moneyLong);
                    continue;
                }
                agregatBuilder.add(0, moneyLong);
                continue;
            }
            MoneyConversion moneyConversion = this.coursManager.getMoneyConversion(this.pivotCurrency, currency);
            if (moneyConversion == null) continue;
            long moneyLong = moneyConversion.convertToPivot(moneyByCurrency.getMoneyLong(i));
            if (subsetItem != null) {
                agregatBuilder.add(subsetItem, 0, moneyLong);
                continue;
            }
            agregatBuilder.add(0, moneyLong);
        }
    }

    @Override
    public void addApport(AnalytiqueRecapBuilder analytiqueRecapBuilder, Ligne ligne) {
        long lg = this.convert(ligne);
        analytiqueRecapBuilder.addApport(0, lg, ligne.getDate());
    }

    @Override
    public void addAvanceNonSoldee(AnalytiqueRecapBuilder analytiqueRecapBuilder, Ligne ligne) {
        long lg = this.convert(ligne);
        analytiqueRecapBuilder.addAvanceNonSoldee(0, -lg, ligne.getDate());
    }

    @Override
    public void addDepense(AnalytiqueRecapBuilder analytiqueRecapBuilder, Ligne ligne) {
        long lg = this.convert(ligne);
        analytiqueRecapBuilder.addDepense(0, -lg, ligne.getDate());
    }

    @Override
    public void addDepenseAvenir(AnalytiqueRecapBuilder analytiqueRecapBuilder, Avenir avenir) {
        long lg = this.convert(avenir);
        analytiqueRecapBuilder.addDepenseAvenir(0, -lg, avenir.getDatePrevue());
    }

    private long convert(Ligne ligne) {
        return AnalytiqueUtils.convert(this.coursManager, this.pivotCurrency, ligne);
    }

    private long convert(Avenir avenir) {
        return AnalytiqueUtils.convert(this.coursManager, this.pivotCurrency, avenir);
    }
}

