/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.html.ficheform;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.FormEntry;
import fr.exemole.bdfserver.api.ficheform.FormEntryProvider;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.tools.ficheform.FormEntryProviderFactory;
import fr.exemole.bdfserver.tools.ficheform.builders.CorpusEntryBuilder;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.pointeurs.FichePointeur;

public class SoldeFormEntryProvider
implements FormEntryProvider {
    private final FicheFormParameters ficheFormParameters;
    private final SoldeFicheFormParameters soldeParameters;
    private final Corpus avanceCorpus;
    private final Corpus depenseCorpus;
    private final FormEntryProvider defaultProvider;

    private SoldeFormEntryProvider(FicheFormParameters ficheFormParameters, SoldeFicheFormParameters soldeParameters) {
        this.ficheFormParameters = ficheFormParameters;
        this.soldeParameters = soldeParameters;
        this.avanceCorpus = soldeParameters.getAvanceCorpus();
        this.depenseCorpus = soldeParameters.getDepenseCorpus();
        this.defaultProvider = FormEntryProviderFactory.newInstance((FicheFormParameters)ficheFormParameters);
    }

    public FormEntry.Include getFormEntry(FichePointeur fichePointeur, IncludeUi includeUi) {
        if (includeUi instanceof SubsetIncludeUi) {
            ExtendedIncludeKey includeKey = ((SubsetIncludeUi)includeUi).getExtendedIncludeKey();
            SubsetKey subsetKey = includeKey.getSubsetKey();
            if (subsetKey.equals((Object)this.avanceCorpus.getSubsetKey())) {
                if (!includeKey.hasWeightFilter() || includeKey.getWeightFilter() == 2) {
                    CorpusEntryBuilder builder = new CorpusEntryBuilder(includeUi.getName(), this.avanceCorpus);
                    int weight = includeKey.getWeightFilter() == 2 ? -1 : 2;
                    for (FicheMeta ficheMeta : this.soldeParameters.getAvanceList()) {
                        builder.addFicheMeta(ficheMeta, weight);
                    }
                    return builder.setHasWeightFilter(includeKey.hasWeightFilter()).populateOptions(this.ficheFormParameters, includeUi).toCorpusEntry();
                }
            } else if (subsetKey.equals((Object)this.depenseCorpus.getSubsetKey()) && (!includeKey.hasWeightFilter() || includeKey.getWeightFilter() == 1)) {
                CorpusEntryBuilder builder = new CorpusEntryBuilder(includeUi.getName(), this.depenseCorpus);
                int weight = includeKey.getWeightFilter() == 1 ? -1 : 1;
                for (FicheMeta ficheMeta : this.soldeParameters.getDepenseList()) {
                    builder.addFicheMeta(ficheMeta, weight);
                }
                return builder.setHasWeightFilter(includeKey.hasWeightFilter()).populateOptions(this.ficheFormParameters, includeUi).toCorpusEntry();
            }
        }
        return this.defaultProvider.getFormEntry(fichePointeur, includeUi);
    }

    public FormEntry.Field getFormEntry(FichePointeur fichePointeur, FieldUi fieldUI) {
        return this.defaultProvider.getFormEntry(fichePointeur, fieldUI);
    }

    public static SoldeFormEntryProvider newInstance(FicheFormParameters ficheFormParameters, SoldeFicheFormParameters parameters) {
        if (parameters.isEmpty()) {
            return null;
        }
        return new SoldeFormEntryProvider(ficheFormParameters, parameters);
    }

    public static class SoldeFicheFormParameters {
        private final List<FicheMeta> avanceList = new ArrayList<FicheMeta>();
        private final List<FicheMeta> depenseList = new ArrayList<FicheMeta>();
        private Corpus avanceCorpus;
        private Corpus depenseCorpus;

        public Corpus getAvanceCorpus() {
            return this.avanceCorpus;
        }

        public Corpus getDepenseCorpus() {
            return this.depenseCorpus;
        }

        public void setAvanceCorpus(Corpus avanceCorpus) {
            this.avanceCorpus = avanceCorpus;
        }

        public void setDepenseCorpus(Corpus depenseCorpus) {
            this.depenseCorpus = depenseCorpus;
        }

        public boolean addAvance(FicheMeta ficheMeta) {
            if (this.avanceList.contains(ficheMeta)) {
                return false;
            }
            this.avanceList.add(ficheMeta);
            return true;
        }

        public boolean addDepense(FicheMeta ficheMeta) {
            if (this.depenseList.contains(ficheMeta)) {
                return false;
            }
            this.depenseList.add(ficheMeta);
            return true;
        }

        public List<FicheMeta> getAvanceList() {
            return this.avanceList;
        }

        public List<FicheMeta> getDepenseList() {
            return this.depenseList;
        }

        public boolean isEmpty() {
            return this.avanceList.isEmpty() && this.depenseList.isEmpty();
        }
    }
}

