/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.html;

import fr.exemole.bdfext.scarabe.Scarabe;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.Recapitulatif;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.producers.html.ScarabeHtmlUtils;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.ParameterMap;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Map;
import java.util.function.Consumer;
import net.fichotheque.Subset;
import net.fichotheque.corpus.FicheMeta;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyUtils;

public class DepenseAvenirHtmlProducer
extends BdfServerHtmlProducer {
    private final ScarabeContext scarabeContext;
    private final Recapitulatif recapitulatif;

    public DepenseAvenirHtmlProducer(BdfParameters bdfParameters, ScarabeContext scarabeContext) {
        super(bdfParameters);
        this.scarabeContext = scarabeContext;
        this.addExtensionThemeCss("scarabe", new String[]{"index.css"});
        this.setBodyCssClass("global-body-ListFrame");
        this.recapitulatif = scarabeContext.getScarabeCache().getRecapitulatif(this.bdfServer);
    }

    public void printHtml() {
        this.start();
        ScarabeHtmlUtils.printRecapitulatifToolList((HtmlPrinter)this, Scarabe.DOMAIN);
        this.printCommandMessageUnit();
        DecimalFormatSymbols symbols = this.getDecimalFormatSymbols();
        DateTimeFormatter dateTimeFormatter = this.getDateTimeFormatter(FormatStyle.MEDIUM);
        this.__((Consumer)PageUnit.start((Object)"_ label.scarabe.depenseavenircount"));
        for (Avenir avenir : this.recapitulatif.getAvenirList()) {
            this.printAvenir(avenir, dateTimeFormatter, symbols);
        }
        this.__(PageUnit.END);
    }

    private void printAvenir(Avenir avenir, DateTimeFormatter dateTimeFormatter, DecimalFormatSymbols symbols) {
        ExtendedCurrency avenirCurrency = avenir.getMontant().getCurrency();
        long avenirMoneyLong = -avenir.getComputeMoneyLong();
        FicheMeta ficheMeta = avenir.getFicheMeta();
        String title = ficheMeta.getTitle();
        if (title.length() == 0) {
            title = "__";
        }
        this.H2().__escape((CharSequence)title).__(ScarabeHtmlUtils.printDisplayButton((HtmlPrinter)this, ficheMeta)).__(ScarabeHtmlUtils.printEditButton((HtmlPrinter)this, ficheMeta)).BR().__escape((CharSequence)MoneyUtils.toLitteralString((long)avenirMoneyLong, (ExtendedCurrency)avenirCurrency, (DecimalFormatSymbols)symbols, (boolean)true))._H2();
        LocalDate date = avenir.getDatePrevue();
        this.P("scarabe-index-DatePrevue").__escape((CharSequence)date.toString()).__space().__escape('(').__escape((CharSequence)dateTimeFormatter.format(date)).__escape(')')._P();
        this.FORM_get("edition", "Edition").INPUT_hidden((Map)ParameterMap.init().subset((Subset)this.scarabeContext.getCoreAliasHolder().getCorpus("mouvement")).page("fiche-creation").param("avenir", String.valueOf(ficheMeta.getId())));
        this.P().__((Consumer)Button.submit((String)"_ link.scarabe.avenirmouvementcreation"))._P();
        this._FORM();
    }
}

