/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.commands;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.commands.SelectionParameters;
import fr.exemole.bdfext.scarabe.selection.MouvementFicheSelector;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfext.scarabe.tools.core.CoreUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.tools.corpus.FichesBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class MouvementSelectionCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "MouvementSelection";
    public static final String WITHLIGNES_PARAMNAME = "withlignes";
    private final ScarabeContext scarabeContext;
    private MouvementFicheSelector mouvementFicheSelector;
    private boolean withLignes = false;

    public MouvementSelectionCommand(BdfServer bdfServer, RequestMap requestHandler, ScarabeContext scarabeContext) {
        super(bdfServer, requestHandler);
        this.scarabeContext = scarabeContext;
    }

    public boolean needSynchronisation() {
        return false;
    }

    protected void doCommand() throws ErrorMessageException {
        Fiches fiches = this.recherche();
        this.bdfServer.getSelectionManager().setCustomSelectedFiches(this.bdfUser, fiches);
        SelectionParameters.putSelectionParameters(this.bdfServer, this.bdfUser, "scarabe.selectionparameters_mouvement", this.mouvementFicheSelector.getSelectionParameters());
    }

    protected void checkParameters() throws ErrorMessageException {
        ScarabeUtils.checkInitState(this.scarabeContext);
        if (this.requestHandler.isTrue(WITHLIGNES_PARAMNAME)) {
            this.withLignes = true;
        }
        SelectionParameters selectionParameters = new SelectionParameters();
        selectionParameters.initDateIntegerFilter(this.requestHandler, "date");
        selectionParameters.initDecimalLongFilter(this.requestHandler, "montant");
        selectionParameters.initPositiveRangeList(this.requestHandler, "numeropiece");
        selectionParameters.initPositiveRangeList(this.requestHandler, "numerocheque");
        selectionParameters.initCondition(this.requestHandler, "beneficiaire", true);
        selectionParameters.initCondition(this.requestHandler, "libelle", true);
        selectionParameters.initCondition(this.requestHandler, "banque", false);
        selectionParameters.initCondition(this.requestHandler, "rapprochement", false);
        selectionParameters.initCondition(this.requestHandler, "modepaiement", false);
        if (selectionParameters.isEmpty()) {
            throw BdfErrors.error((String)"_ error.empty.selectionparameters");
        }
        this.mouvementFicheSelector = new MouvementFicheSelector(this.bdfServer, this.scarabeContext, this.bdfUser, selectionParameters);
    }

    private Fiches recherche() {
        FichesBuilder fichesBuilder = FichesBuilder.build((String)"creationdate-desc").initSubsetKeyOrder(TreeUtils.getCorpusKeyList((BdfServer)this.bdfServer));
        Corpus mouvementCorpus = this.scarabeContext.getCoreAliasHolder().getCorpus("mouvement");
        for (FicheMeta ficheMeta : mouvementCorpus.getFicheMetaList()) {
            boolean test = this.mouvementFicheSelector.test(ficheMeta);
            if (!test) continue;
            fichesBuilder.add(ficheMeta);
            if (!this.withLignes) continue;
            CoreUtils.Lists lists = this.mouvementFicheSelector.getCurrentMouvementLists();
            fichesBuilder.addAll(lists.getAvanceList()).addAll(lists.getSoldeAvanceList()).addAll(lists.getDepenseList()).addAll(lists.getApportList());
        }
        return fichesBuilder.toFiches();
    }
}

