/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.resourcesupdate;

import fr.exemole.bdfext.resourcesupdate.tools.conversion.zip.PagesZipEngine;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.zip.ZipOutputStream;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.utils.FormatterUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.io.ZipStreamProducer;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.SimpleResponseHandler;
import net.mapeadores.util.servlets.handlers.StreamResponseHandler;

public class PagesZipBdfInstruction
implements BdfInstruction {
    private final BdfServer bdfServer;
    private final String name;

    public PagesZipBdfInstruction(BdfServer bdfServer, String name) {
        this.bdfServer = bdfServer;
        this.name = name;
    }

    public short getBdfUserNeed() {
        return 1;
    }

    public ResponseHandler runInstruction(BdfUser bdfUser) {
        SubsetKey subsetKey;
        try {
            subsetKey = SubsetKey.parse((short)1, (String)this.name);
        }
        catch (ParseException pe) {
            return SimpleResponseHandler.init((String)("Wrong corpus name: " + this.name));
        }
        Corpus corpus = (Corpus)this.bdfServer.getFichotheque().getSubset(subsetKey);
        if (corpus == null) {
            return SimpleResponseHandler.init((String)("Unknown corpus: " + this.name));
        }
        return StreamResponseHandler.init((StreamProducer)new PagesZipStreamProducer(this.bdfServer, corpus));
    }

    private static class PagesZipStreamProducer
    extends ZipStreamProducer {
        private final Corpus corpus;
        private final BdfServer bdfServer;

        private PagesZipStreamProducer(BdfServer bdfServer, Corpus corpus) {
            this.corpus = corpus;
            this.bdfServer = bdfServer;
        }

        public void writeZipStream(ZipOutputStream zipOutputStream) throws IOException {
            ExtractionContext extractionContext = BdfServerUtils.initAdminExtractionContextBuilder((BdfServer)this.bdfServer).toExtractionContext();
            FormatContext formatContext = this.bdfServer.getFormatContext();
            FichePointeur fichePointeur = PointeurFactory.newFichePointeur((Corpus)this.corpus);
            FormatSource formatSource = FormatterUtils.toFormatSource((SubsetItemPointeur)fichePointeur, (ExtractionContext)extractionContext, null, (FormatContext)formatContext);
            PagesZipEngine.zip(formatSource, formatContext, zipOutputStream);
        }
    }
}

