/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.layers.common;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.desmodo.atlas.display.blocks.BlockLocator;
import net.desmodo.atlas.display.blocks.LiaisonBlock;
import net.desmodo.atlas.display.icons.NumberIcon;
import net.desmodo.atlas.display.layers.Layer;
import net.desmodo.atlas.ventilation.Liaison;

public class LienIndexLayer
implements Layer {
    private BlockLocator blockLocator;
    private final List<InternalIndexIcon> iconList = new ArrayList<InternalIndexIcon>();
    private String name;
    private int index;

    @Override
    public void setBlockLocator(BlockLocator blockLocator) {
        this.blockLocator = blockLocator;
    }

    @Override
    public void update() {
        this.iconList.clear();
        for (LiaisonBlock liaisonBlock : this.blockLocator.getLiaisonBlockList()) {
            Liaison liaison;
            int number;
            short boxType;
            if (!liaisonBlock.isLienNaturel() || (boxType = liaisonBlock.getBoxType()) != 2 || (number = (liaison = liaisonBlock.getLiaison()).getIndexInLien() + 1) == 0) continue;
            Rectangle rect = liaisonBlock.getRectangle();
            Point P = new Point(rect.x, rect.y + rect.height - 1);
            this.iconList.add(new InternalIndexIcon(P, liaisonBlock.getBoxSkin().getBorderColor(), number));
        }
    }

    @Override
    public void paintLayer(Graphics2D g) {
        for (InternalIndexIcon indexIcon : this.iconList) {
            indexIcon.paint(g);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    private class InternalIndexIcon {
        private final Point P;
        private final int number;
        private final NumberIcon numberIcon;
        private final Color borderColor;

        private InternalIndexIcon(Point P, Color borderColor, int number) {
            this.P = P;
            this.borderColor = borderColor;
            this.number = number;
            this.numberIcon = new NumberIcon(number);
            this.numberIcon.setBackgroundColor(Color.WHITE);
            this.numberIcon.setColor(Color.BLUE);
            this.numberIcon.setPadding(1);
            this.numberIcon.setBorder(1, borderColor);
        }

        void paint(Graphics2D g) {
            int x = this.P.x;
            int y = this.P.y - 8;
            this.numberIcon.paintIcon(null, g, x - 2, y + 1);
        }
    }
}

