/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.layers.common;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.boxes.TextBox;
import net.desmodo.atlas.boxes.TextBoxManager;
import net.desmodo.atlas.display.blocks.BlockUtils;
import net.desmodo.atlas.display.blocks.LiaisonBlock;
import net.desmodo.atlas.display.secteurs.FaisceauAngulaire;
import net.desmodo.atlas.display.secteurs.secteurangulaire.SecteurAngulaire;
import net.desmodo.atlas.display.secteurs.secteurangulaire.SecteurAngulaireUtils;
import net.desmodo.atlas.ventilation.Liaison;
import net.desmodo.atlas.ventilation.LiaisonList;
import net.desmodo.atlas.ventilation.Secteur;
import net.mapeadores.util.geometry.CartesianOrigin;

public class LiaisonBlockLayer {
    private static final float[] rapports = new float[]{0.5f, 0.25f, 0.75f, 0.125f, 0.625f, 0.375f, 0.875f, 0.0625f, 0.5625f, 0.3125f, 0.8125f, 0.1875f, 0.6875f, 0.4375f, 0.9375f};
    private final TextBoxManager textBoxManager;
    private final List<LiaisonBlock> liaisonBlockList = new ArrayList<LiaisonBlock>();
    private final List<LiaisonBlock> unmodifiableList = Collections.unmodifiableList(this.liaisonBlockList);
    private final Map<Integer, LiaisonBlock> liaisonBlockMap = new HashMap<Integer, LiaisonBlock>();
    private Point graphicCenter;
    private Rectangle[] rectangles = new Rectangle[32];
    private int rectangleSize = 0;
    private Rectangle globalRectangle;

    public LiaisonBlockLayer(TextBoxManager textBoxManager) {
        this.textBoxManager = textBoxManager;
    }

    public List getLiaisonBlockList() {
        return this.unmodifiableList;
    }

    public LiaisonBlock getLiaisonBlockAt(Point P) {
        int size = this.liaisonBlockList.size();
        for (int i = 0; i < size; ++i) {
            LiaisonBlock liaisonBlock = this.liaisonBlockList.get(i);
            if (!liaisonBlock.contains(P)) continue;
            return liaisonBlock;
        }
        return null;
    }

    public Rectangle getGlobalRectangle() {
        return this.globalRectangle;
    }

    public LiaisonBlock getLiaisonBlock(int ventilationcode) {
        return this.liaisonBlockMap.get(ventilationcode);
    }

    public void clearExistingRectangles() {
        this.rectangleSize = 0;
        this.globalRectangle = null;
    }

    public void clearLiaisonBlocks() {
        this.liaisonBlockList.clear();
        this.liaisonBlockMap.clear();
    }

    public void init(FaisceauAngulaire faisceauAngulaire, CartesianOrigin cartesianOrigin, boolean clearboxes) {
        if (clearboxes) {
            this.clearLiaisonBlocks();
        }
        this.graphicCenter = cartesianOrigin.toGraphicPoint(faisceauAngulaire.getCartesianCenter());
        int secteurAngulaireCount = faisceauAngulaire.getSecteurAngulaireCount();
        for (int i = 0; i < secteurAngulaireCount; ++i) {
            SecteurAngulaire secteurAngulaire = faisceauAngulaire.getSecteurAngulaire(i);
            Secteur secteur = secteurAngulaire.getSecteur();
            LiaisonList liste = secteur.getLiaisonList();
            int liaisonCount = liste.getLiaisonCount();
            int p = 1;
            if (secteurAngulaireCount < 3) {
                p = 2;
            }
            for (int j = 0; j < liaisonCount; ++j) {
                Liaison liaison = liste.getLiaison(j);
                LiaisonBlock liaisonBlock = clearboxes ? this.createLiaisonBlock(liaison) : this.reinitLiaisonBlock(liaison);
                double angle = SecteurAngulaireUtils.getCartesianEllipseAngle(secteurAngulaire, this.getRapport(p));
                Translation translation = this.translation(angle, 10);
                Rectangle2D.Double rect2D = new Rectangle2D.Double();
                ((Rectangle2D)rect2D).setRect(liaisonBlock.getRectangle());
                this.translate(rect2D, translation, 3);
                this.checkIntersection(rect2D, translation);
                liaisonBlock.setRectangle(new Rectangle((int)Math.round(((RectangularShape)rect2D).getX()), (int)Math.round(((RectangularShape)rect2D).getY()), (int)Math.round(((RectangularShape)rect2D).getWidth()), (int)Math.round(((RectangularShape)rect2D).getHeight())));
                this.addExistingRectangle(liaisonBlock.getRectangle(), 2);
                this.liaisonBlockList.add(liaisonBlock);
                ++p;
            }
        }
    }

    public void addExistingRectangle(Rectangle nouveau, int margin) {
        Rectangle rectbord;
        if (this.rectangles.length == this.rectangleSize) {
            Rectangle[] nv = new Rectangle[this.rectangleSize * 2];
            System.arraycopy(this.rectangles, 0, nv, 0, this.rectangleSize);
            this.rectangles = nv;
        }
        this.rectangles[this.rectangleSize] = rectbord = new Rectangle(nouveau.x - margin, nouveau.y - margin, nouveau.width + margin * 2, nouveau.height + margin * 2);
        this.addToGlobal(rectbord);
        ++this.rectangleSize;
    }

    private void addToGlobal(Rectangle rect) {
        this.globalRectangle = this.globalRectangle == null ? rect : this.globalRectangle.union(rect);
    }

    private void translate(Rectangle2D rect2D, Translation translation, int factor) {
        rect2D.setRect(rect2D.getX() + translation.getX() * (double)factor, rect2D.getY() + translation.getY() * (double)factor, rect2D.getWidth(), rect2D.getHeight());
    }

    private void checkIntersection(Rectangle2D nouveau, Translation translation) {
        for (int i = this.rectangleSize - 1; i >= 0; --i) {
            Rectangle existant = this.rectangles[i];
            if (!existant.intersects(nouveau)) continue;
            this.translate(nouveau, translation, 1);
            while (existant.intersects(nouveau)) {
                this.translate(nouveau, translation, 1);
            }
            this.checkIntersection(nouveau, translation);
            break;
        }
    }

    private float getRapport(int q) {
        int dif;
        if (q <= 15) {
            return rapports[q - 1];
        }
        int i = (int)Math.ceil(Math.sqrt((double)q * 2.0));
        int ki = i * (i - 1) / 2;
        if (ki >= q) {
            ki = --i * (i - 1) / 2;
        }
        float result = ((dif = q - ki) & 1) == 0 ? 1.0f - (float)dif / (2.0f * ((float)i + 1.0f)) : (float)(dif + 1) / (2.0f * ((float)i + 1.0f));
        return result;
    }

    private LiaisonBlock reinitLiaisonBlock(Liaison liaison) {
        LiaisonBlock liaisonBlock = this.liaisonBlockMap.get(liaison.getVentilationCode());
        if (liaisonBlock == null) {
            return this.createLiaisonBlock(liaison);
        }
        Rectangle rect = liaisonBlock.getRectangle();
        Point L = BlockUtils.getNorthWest(this.graphicCenter.x, this.graphicCenter.y, 0, rect.width, rect.height);
        rect.setLocation(L);
        return liaisonBlock;
    }

    private LiaisonBlock createLiaisonBlock(Liaison liaison) {
        Term term = liaison.getTerm();
        short typebox = 0;
        switch (liaison.getPosition()) {
            case 1: {
                typebox = 2;
                break;
            }
            case 3: {
                typebox = 1;
                break;
            }
            case 2: {
                typebox = 3;
                break;
            }
            default: {
                throw new IllegalStateException("unknown liaison.getPosition() value");
            }
        }
        TextBox textBox = this.textBoxManager.getTextBox(typebox, term.getCode());
        Dimension dimension = textBox.getDimension();
        Point L = BlockUtils.getNorthWest(this.graphicCenter, 0, dimension);
        LiaisonBlock liaisonBlock = new LiaisonBlock(liaison, textBox, new Rectangle(L, dimension), typebox);
        this.liaisonBlockMap.put(liaison.getVentilationCode(), liaisonBlock);
        return liaisonBlock;
    }

    private Translation translation(double angle, int extent) {
        double ytranslation;
        double xtranslation;
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        if (Math.abs(cos) > 0.5) {
            xtranslation = cos > 0.0 ? (double)extent : (double)(-extent);
            ytranslation = (double)(-extent) * (sin / Math.abs(cos));
        } else {
            xtranslation = (double)extent * (cos / Math.abs(sin));
            ytranslation = sin > 0.0 ? (double)(-extent) : (double)extent;
        }
        return new Translation(xtranslation, ytranslation);
    }

    private static class Translation {
        private double x;
        private double y;

        Translation(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }
}

