/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.icons;

import java.awt.Color;
import java.awt.Graphics;
import net.desmodo.atlas.display.GraphicsUtils;
import net.desmodo.atlas.display.icons.LienIcon;

public class NumberIcon
extends LienIcon {
    private static final int CHAR_WIDTH = 5;
    private static final int CHAR_HEIGHT = 8;
    private final String numberString;
    private Color color = Color.BLACK;

    public NumberIcon(int number) {
        this.numberString = String.valueOf(number);
        int length = this.numberString.length();
        this.setInnerDimension(length * 5 + (length - 1), 8);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    protected void paintFigure(Graphics g, int x, int y) {
        g.setColor(this.color);
        Draw draw = new Draw(g, x, y);
        draw.paint(this.numberString);
    }

    private class Draw {
        private final Graphics g;
        private int currentX;
        private final int currentY;

        Draw(Graphics g, int x, int y) {
            this.g = g;
            this.currentX = x - 1;
            this.currentY = y - 1;
        }

        void paint(String s) {
            int length = s.length();
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    ++this.currentX;
                }
                this.printChar(s.charAt(i));
                this.currentX += 5;
            }
        }

        private void printChar(char carac) {
            switch (carac) {
                case '0': {
                    this.print0();
                    break;
                }
                case '1': {
                    this.print1();
                    break;
                }
                case '2': {
                    this.print2();
                    break;
                }
                case '3': {
                    this.print3();
                    break;
                }
                case '4': {
                    this.print4();
                    break;
                }
                case '5': {
                    this.print5();
                    break;
                }
                case '6': {
                    this.print6();
                    break;
                }
                case '7': {
                    this.print7();
                    break;
                }
                case '8': {
                    this.print8();
                    break;
                }
                case '9': {
                    this.print9();
                }
            }
        }

        private void point(int x, int y) {
            GraphicsUtils.drawPoint(this.g, this.currentX + x, this.currentY + y);
        }

        private void ligneH(int x, int y, int length) {
            GraphicsUtils.drawHorizontalLine(this.g, this.currentX + x, this.currentY + y, length);
        }

        private void ligneV(int x, int y, int length) {
            GraphicsUtils.drawVerticalLine(this.g, this.currentX + x, this.currentY + y, length);
        }

        private void print0() {
            this.ligneH(2, 1, 3);
            this.ligneV(1, 2, 6);
            this.ligneH(2, 8, 3);
            this.ligneV(5, 2, 6);
        }

        private void print1() {
            this.ligneV(3, 1, 8);
            this.point(2, 2);
            this.point(2, 8);
            this.point(4, 8);
        }

        void print2() {
            this.ligneH(1, 1, 4);
            this.ligneV(5, 2, 2);
            this.point(4, 4);
            this.point(3, 5);
            this.point(2, 6);
            this.point(1, 7);
            this.ligneH(1, 8, 5);
        }

        void print3() {
            this.ligneH(1, 1, 4);
            this.ligneV(5, 2, 2);
            this.ligneH(2, 4, 3);
            this.ligneV(5, 5, 3);
            this.ligneH(1, 8, 4);
        }

        void print4() {
            this.ligneV(4, 1, 8);
            this.ligneH(1, 6, 3);
            this.ligneV(2, 3, 2);
            this.point(3, 2);
            this.point(1, 5);
            this.point(5, 6);
        }

        void print5() {
            this.ligneH(2, 1, 4);
            this.ligneV(2, 2, 3);
            this.ligneH(3, 4, 2);
            this.ligneV(5, 5, 3);
            this.ligneH(2, 8, 3);
        }

        void print6() {
            this.ligneH(3, 1, 3);
            this.point(2, 2);
            this.ligneV(1, 3, 5);
            this.ligneH(2, 4, 3);
            this.ligneV(5, 5, 3);
            this.ligneH(2, 8, 3);
        }

        void print7() {
            this.ligneH(1, 1, 5);
            this.point(5, 2);
            this.ligneV(4, 3, 2);
            this.ligneV(3, 5, 2);
            this.ligneV(2, 7, 2);
        }

        void print8() {
            this.ligneH(2, 1, 3);
            this.ligneV(1, 2, 2);
            this.ligneV(5, 2, 2);
            this.ligneH(2, 4, 3);
            this.ligneV(1, 5, 3);
            this.ligneV(5, 5, 3);
            this.ligneH(2, 8, 3);
        }

        void print9() {
            this.ligneH(2, 1, 3);
            this.ligneV(1, 2, 3);
            this.ligneV(5, 2, 5);
            this.ligneH(2, 5, 3);
            this.point(4, 7);
            this.ligneH(1, 8, 3);
        }
    }
}

