/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.conf;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.File;
import java.text.MessageFormat;
import java.text.ParseException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.primitives.PositiveInteger;
import net.mapeadores.util.text.tableparser.CsvParameters;
import net.mapeadores.util.text.tableparser.TableParser;

public final class ConfUtils {
    private ConfUtils() {
    }

    public static Boolean booleanTest(String value) {
        if (value.equalsIgnoreCase("true") || value.equals("1")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("false") || value.equals("0")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static Integer integerTest(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static PositiveInteger positiveIntegerTest(String value) {
        try {
            int i = Integer.parseInt(value);
            if (i <= 0) {
                return null;
            }
            return new PositiveInteger(i);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static Lang langTest(String value) {
        try {
            return Lang.parse((String)value);
        }
        catch (ParseException nfe) {
            return null;
        }
    }

    public static MessageFormat messageFormatTest(String value) {
        try {
            return new MessageFormat(value);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public static File directoryTest(String value) {
        File file = new File(value);
        if (!file.isDirectory() && (file = file.getParentFile()) == null) {
            return null;
        }
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (SecurityException ioe) {
                return null;
            }
        }
        return file;
    }

    public static String[] toStringArray(String string) {
        if (string.length() == 0) {
            return new String[0];
        }
        String[][] lignes = TableParser.parse((String)string, (TableParser.Parameters)new CsvParameters());
        int lignesLength = lignes.length;
        if (lignesLength == 0) {
            return new String[0];
        }
        if (lignesLength == 1) {
            return lignes[0];
        }
        int total = 0;
        for (int i = 0; i < lignesLength; ++i) {
            total += lignes[i].length;
        }
        String[] result = new String[total];
        int p = 0;
        for (int i = 0; i < lignesLength; ++i) {
            String[] ligne;
            String[] stringArray = ligne = lignes[i];
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String token;
                result[p] = token = stringArray[j];
                ++p;
            }
        }
        return result;
    }

    public static Rectangle toRectangle(String string) {
        String[] tab = string.split(",");
        if (tab.length != 4) {
            return new Rectangle(60, 60, 420, 420);
        }
        int[] intValues = new int[4];
        for (int i = 0; i < 4; ++i) {
            try {
                intValues[i] = Integer.parseInt(tab[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                intValues[i] = i < 2 ? 60 : 420;
            }
        }
        return new Rectangle(intValues[0], intValues[1], intValues[2], intValues[3]);
    }

    public static Font toFont(String string) {
        String fontName = null;
        String[] tab = string.split(";");
        int fontStyle = 0;
        int fontSize = 11;
        for (String token : tab) {
            int idx;
            if (!(token = token.trim()).startsWith("font-") || (idx = (token = token.substring(5)).indexOf(58)) < 0) continue;
            String value = token.substring(idx + 1).trim();
            if (token.startsWith("family")) {
                int idxvirg = value.indexOf(44);
                if (idxvirg != -1) {
                    value = value.substring(0, idxvirg).trim();
                }
                if (value.startsWith("\"")) {
                    value = value.substring(1);
                }
                if (value.endsWith("\"")) {
                    value = value.substring(0, value.length() - 1);
                }
                fontName = value;
                continue;
            }
            if (token.startsWith("size")) {
                try {
                    if (value.endsWith("pt")) {
                        fontSize = (int)Float.parseFloat(value.substring(0, value.length() - 2));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (fontSize >= 4) continue;
                fontSize = 4;
                continue;
            }
            if (token.startsWith("style")) {
                if (!value.equals("italic")) continue;
                fontStyle |= 2;
                continue;
            }
            if (!token.startsWith("weight") || !value.equals("bold")) continue;
            fontStyle |= 1;
        }
        if (fontName != null) {
            String[] fontes = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            boolean existe = false;
            for (String fonte : fontes) {
                if (fonte.compareToIgnoreCase(fontName) != 0) continue;
                fontName = fonte;
                existe = true;
                break;
            }
            if (!existe) {
                fontName = null;
            }
        }
        if (fontName == null) {
            fontName = "SansSerif";
        }
        return new Font(fontName, fontStyle, fontSize);
    }

    public static String toString(Font font) {
        String fontname = font.getName();
        float fontsize = font.getSize();
        int fontstyle = font.getStyle();
        StringBuilder buf = new StringBuilder();
        buf.append("font-family:");
        if (fontname.indexOf(32) > -1) {
            buf.append('\"');
            buf.append(fontname);
            buf.append('\"');
        } else {
            buf.append(fontname);
        }
        buf.append(';');
        buf.append("font-size:");
        buf.append(String.valueOf(fontsize));
        buf.append("pt");
        buf.append(';');
        buf.append("font-style:");
        if ((fontstyle & 2) != 0) {
            buf.append("italic");
        } else {
            buf.append("normal");
        }
        buf.append(';');
        buf.append("font-weight:");
        if ((fontstyle & 1) != 0) {
            buf.append("bold");
        } else {
            buf.append("normal");
        }
        buf.append(';');
        return buf.toString();
    }

    public static String toString(Object value) {
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return "true";
            }
            return "false";
        }
        if (value instanceof File) {
            return ((File)value).getPath();
        }
        if (value instanceof Font) {
            return ConfUtils.toString((Font)value);
        }
        if (value instanceof Rectangle) {
            return ConfUtils.toString((Rectangle)value);
        }
        if (value instanceof MessageFormat) {
            return ((MessageFormat)value).toPattern();
        }
        if (value instanceof String[]) {
            return ConfUtils.toString((String[])value);
        }
        return value.toString();
    }

    public static String toString(Rectangle rectangle) {
        StringBuilder buf = new StringBuilder();
        buf.append(rectangle.x);
        buf.append(',');
        buf.append(rectangle.y);
        buf.append(',');
        buf.append(rectangle.width);
        buf.append(',');
        buf.append(rectangle.height);
        return buf.toString();
    }

    public static String toString(String[] stringArray) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                buf.append(',');
            }
            boolean quoted = false;
            StringBuilder smallBuf = new StringBuilder();
            String strg = stringArray[i];
            for (int j = 0; j < strg.length(); ++j) {
                char carac = strg.charAt(j);
                if (carac == '\"') {
                    smallBuf.append("\\\"");
                    quoted = true;
                    continue;
                }
                if (carac == '\\') {
                    smallBuf.append("\\\\");
                    quoted = true;
                    continue;
                }
                smallBuf.append(carac);
                if (carac <= '~' && carac >= '!' && carac != ',' && carac != ';' && carac != '\'') continue;
                quoted = true;
            }
            if (quoted) {
                buf.append('\"');
            }
            buf.append(smallBuf.toString());
            if (!quoted) continue;
            buf.append('\"');
        }
        return buf.toString();
    }
}

