/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.comptaexemole;

import com.Ostermiller.util.CSVParser;
import fr.exemole.bdfext.comptaexemole.LigneError;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.mapeadores.util.logging.ErrorMessageException;

public class FileParser {
    private static final String[] LIGNE_DOUBLE = new String[0];
    private final Map<String, String[]> ligneMap = new TreeMap<String, String[]>();
    private final List<LigneError> errorList = new ArrayList<LigneError>();
    private Set<String> planComptable;

    public void setPlanComptable(Set<String> planComptable) {
        this.planComptable = planComptable;
    }

    public void parse(InputStream inputStream) throws ErrorMessageException {
        String[][] valeurs = null;
        try (InputStreamReader reader = new InputStreamReader(inputStream, "ISO-8859-1");){
            CSVParser csvParser = new CSVParser(reader, '\t');
            valeurs = csvParser.getAllValues();
        }
        catch (IOException ioe) {
            throw BdfErrors.internalError((String)("error with file = " + ioe.getLocalizedMessage()));
        }
        for (int i = 0; i < valeurs.length; ++i) {
            String[] ligneArray = valeurs[i];
            int length = ligneArray.length;
            if (length <= 5) continue;
            try {
                int compte = Integer.parseInt(ligneArray[4]);
                if (compte < 600000 || compte >= 800000) continue;
                this.addLigne(i + 1, ligneArray);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public boolean hasError() {
        return !this.errorList.isEmpty();
    }

    public List<LigneError> getErrorList() {
        return this.errorList;
    }

    public Map<String, String[]> getLigneMap() {
        return this.ligneMap;
    }

    private void addLigne(int numero, String[] ligne) {
        String journal = ligne[1];
        String codePiece = ligne[2];
        String plan = ligne[4];
        if (!this.planComptable.contains(plan)) {
            this.addError(numero, "Plan comptable inconnu : " + plan, ligne, null);
            return;
        }
        String key = journal + "-" + codePiece + "-" + plan;
        if (this.ligneMap.containsKey(key)) {
            String[] ligneActuelle = this.ligneMap.get(key);
            if (ligneActuelle == LIGNE_DOUBLE) {
                this.addError(numero, "Triplon : " + key, ligne, null);
            } else {
                String[] ligne1 = this.ligneMap.get(key);
                this.addError(numero, "Identification en double : " + key, ligne1, ligne);
                this.ligneMap.put(key, LIGNE_DOUBLE);
            }
        } else {
            this.ligneMap.put(key, ligne);
        }
    }

    private void addError(int numero, String text, String[] ligne1, String[] ligne2) {
        LigneError error = new LigneError(numero, text, ligne1, ligne2);
        this.errorList.add(error);
    }
}

