/* FichothequeLib_API - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.utils;

import net.fichotheque.importation.ParentChange;


/**
 *
 * @author Vincent Calame
 */
public final class ParentChangeUtils {

    public final static ParentChange.Thesaurus THESAURUS = new ThesaurusParentChange();

    private ParentChangeUtils() {

    }

    public static ParentChange.Id toIdParentChange(int id) {
        return new IdParentChange(id);
    }

    public static ParentChange.Idalpha toIdalphaParentChange(String idalpha) {
        return new IdalphaParentChange(idalpha);
    }


    private static class ThesaurusParentChange implements ParentChange.Thesaurus {

    }


    private static class IdParentChange implements ParentChange.Id {

        private final int id;

        private IdParentChange(int id) {
            this.id = id;
        }

        @Override
        public int getParentId() {
            return id;

        }

    }


    private static class IdalphaParentChange implements ParentChange.Idalpha {

        private final String idalpha;

        private IdalphaParentChange(String idalpha) {
            this.idalpha = idalpha;
        }

        @Override
        public String getParentIdalpha() {
            return idalpha;

        }

    }

}
