/* FichothequeLib_API - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.corpus.metadata;

import net.mapeadores.util.localisation.Lang;


/**
 *
 * @author Vincent Calame
 */
public class LangSubfieldKey extends SubfieldKey {

    private final Lang lang;

    public LangSubfieldKey(FieldKey fieldKey, Lang lang) {
        super(fieldKey, SubfieldKey.LANG_SUBTYPE);
        this.lang = lang;
    }

    @Override
    public int hashCode() {
        return fieldKey.hashCode() + lang.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        LangSubfieldKey fk = (LangSubfieldKey) other;
        if (!fk.fieldKey.equals(this.fieldKey)) {
            return false;
        }
        return fk.lang.equals(this.lang);
    }

    @Override
    public String toString() {
        return fieldKey.getKeyString() + "_" + SubfieldKey.LANG_SUBTYPE + "_" + lang.toString();
    }

}
