/* BdfServer_Multi - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.multi.subscribe;

import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.PersonCore;


/**
 *
 * @author Vincent Calame
 */
public final class SubscribeUtils {

    public final static SubscribeManager INACTIVE_SUBSCRIBEMANAGER = new InactiveSubscribeManager();

    private SubscribeUtils() {

    }


    private static class InactiveSubscribeManager implements SubscribeManager {

        private InactiveSubscribeManager() {

        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public CommandMessage sendToken(PersonCore personCore, EmailCore emailCore, MessageLocalisation messageLocalisation, String multiRootUrl) throws ErrorMessageException {
            throw new UnsupportedOperationException("Inactive Manager");
        }

        @Override
        public SubscribeToken getSubcribeToken(String token) {
            throw new UnsupportedOperationException("Inactive Manager");
        }

    }

}
