/* BdfServer_DirectoryStorage - Copyright (c) 2006-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.storage.directory.bdfdata;

import fr.exemole.bdfserver.conf.ConfConstants;
import fr.exemole.bdfserver.conf.ConfDirs;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.storage.directory.StorageDirectoryUtils;
import java.io.File;
import net.fichotheque.SubsetKey;


/**
 *
 * @author Vincent Calame
 */
public class BdfdataDirectory implements StorageDirectory {

    private final File bdfdataDir;
    private final File backupDir;
    private final File cacheDir;

    public BdfdataDirectory(File bdfdataDir, File cacheDir, File backupDir) {
        StorageDirectoryUtils.testDirectory(bdfdataDir);
        this.bdfdataDir = bdfdataDir;
        if (cacheDir != null) {
            StorageDirectoryUtils.testDirectory(cacheDir);
            this.cacheDir = cacheDir;
        } else {
            this.cacheDir = null;
        }
        if (backupDir != null) {
            StorageDirectoryUtils.testDirectory(backupDir);
            this.backupDir = backupDir;
        } else {
            this.backupDir = null;
        }
        testRelativePath(BdfdataConstants.CONF);
        testRelativePath(BdfdataConstants.USERS);
        testRelativePath(BdfdataConstants.FICHOTHEQUE);
    }

    /**
     * Les répertoires par catégorie sont sous la forme fichotheque/{categorie}.
     * Cette méthode crèe le répertoire pour la catégorie si elle n'existe pas.
     */
    public void testCategoryDirectory(short category) {
        String categoryString = SubsetKey.categoryToString(category);
        File directory = getDataFile(BdfdataConstants.FICHOTHEQUE + File.separator + categoryString);
        directory.mkdirs();
    }

    private void testRelativePath(String path) {
        File testDirectory = new File(bdfdataDir, path);
        StorageDirectoryUtils.testDirectory(testDirectory);
    }

    @Override
    public File getDataDir() {
        return bdfdataDir;
    }

    @Override
    public File getBackupDir() {
        return backupDir;
    }

    public File getCacheDir() {
        return cacheDir;
    }

    public static BdfdataDirectory build(ConfDirs dirs) {
        String subdirName = BdfdataConstants.ROOT;
        File bdfdataDir = dirs.getSubPath(ConfConstants.VAR_DATA, subdirName);
        File backupDir = dirs.getSubPath(ConfConstants.VAR_BACKUP, subdirName);
        File cacheDir = dirs.getDir(ConfConstants.VAR_CACHE);
        return new BdfdataDirectory(bdfdataDir, cacheDir, backupDir);
    }

}
