/* global Fql,Fapi,Bdf,$$,Dashboard,Navigation */
var ARGS = {
};

const CACHE_SETTINGS = {
    api: {
        version: "action"
    },
    thesaurus: [
        /*
         "name"
         */
    ],
    fiches: [
        /*{
            key: "",
            query: {
            },
            sort: ""
        }*/
    ]
};
const DASHBOARD_ENTRIES = [
    /*{
        name: "",
        title: ""
    },*/
];
const DEFAULT_NAVIGATION = new Navigation("");

var API_CACHE = null;

function endCacheInit(apiCache, navigationAtStart) {
    checkNavigation(navigationAtStart);
}

function checkNavigation(navigation) {
    Bdf.$({dashboardEntry: true}).each(function(index, element) {
        if (element.dataset.dashboardEntry === navigation.name) {
            element.classList.remove("hidden");
        } else {
            element.classList.add("hidden");
        }
    });
}

$(function () {
    var navigationAtStart = Navigation.getCurrent(DEFAULT_NAVIGATION);
    Bdf.initTemplates();
    Dashboard.init({
        mainHtml: Bdf.render("main", {
            entries: DASHBOARD_ENTRIES
        }),
        navHtml: Bdf.render("nav", {
            entries: DASHBOARD_ENTRIES
        }),
        toolbarHtml: Bdf.render("toolbar", {
            entries: DASHBOARD_ENTRIES,
            selected: navigationAtStart.name
        }),
        withNav: true,
        withRefresh: true,
        refreshFunction: function () {
            var currentNavigation = Navigation.getCurrent(DEFAULT_NAVIGATION);
        }
    });
    $("#toolbar_tableselect").on("change", Navigation.selectListener);
    Fapi.Cache.init(CACHE_SETTINGS, function (apiCache) {
        API_CACHE = apiCache;
        endCacheInit(apiCache, navigationAtStart);
    });
});
