/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.utils.instructions;

import fr.exemole.bdfext.utils.instructions.UtilsInstruction;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.EditionEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fichotheque.ExistingIdException;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.request.TableIteratorRequestMap;
import net.mapeadores.util.text.tableparser.CsvParameters;
import net.mapeadores.util.text.tableparser.TableParser;

public class ImportQr
extends UtilsInstruction {
    private static final Pattern pattern = Pattern.compile("([0-9]{1,2})/([0-9]{1,2})/([0-9]{1,2})");
    private final Set<Integer> idSet = new HashSet<Integer>();

    @Override
    public Object runInstruction() {
        int i;
        CsvParameters csvParameters;
        SubsetKey subsetKey;
        int idIndex = -1;
        int dateIndex = -1;
        int count = 0;
        int errorCount = 0;
        boolean simulation = this.requestMap.isTrue("simulation");
        String paramFile = this.requestMap.getParameter("file");
        if (paramFile == null) {
            return "Param\u00e8tre file non d\u00e9fini";
        }
        File file = new File(paramFile);
        if (!file.exists()) {
            return "Fichier introuvable : " + paramFile;
        }
        if (file.isDirectory()) {
            return "Le fichier est un r\u00e9pertoire : " + paramFile;
        }
        String champDate = this.requestMap.getParameter("date");
        if (champDate == null) {
            return "Param\u00e8te date (champ date) non d\u00e9fini";
        }
        String corpusName = this.requestMap.getParameter("corpus");
        if (corpusName == null) {
            return "Param\u00e8tre corpus absent";
        }
        try {
            subsetKey = SubsetKey.parse((short)1, (String)corpusName);
        }
        catch (ParseException pe) {
            return "Nom de corpus incorrect";
        }
        Corpus corpus = (Corpus)this.bdfServer.getFichotheque().getSubset(subsetKey);
        if (corpus == null) {
            return "Corpus inconnu";
        }
        String csvString = this.getCSVString(file);
        String[][] valeurs = TableParser.parse((String)csvString, (TableParser.Parameters)(csvParameters = new CsvParameters()));
        int length = valeurs.length;
        if (length < 2) {
            return "fichier vide";
        }
        String[] fieldLine = valeurs[0];
        int maxLength = fieldLine.length;
        if (maxLength == 0) {
            return "aucun champ de d\u00e9fini";
        }
        for (i = 2; i < length; ++i) {
            if (valeurs[i].length <= maxLength) continue;
            int line = i + 1;
            return "Ligne de valeurs trop longue : " + line;
        }
        for (i = 0; i < maxLength; ++i) {
            String name = fieldLine[i];
            if (name.equals("id")) {
                idIndex = i;
                continue;
            }
            if (!name.equals(champDate)) continue;
            dateIndex = i;
        }
        if (idIndex == -1) {
            return "Champ id absent";
        }
        if (dateIndex == -1) {
            return "Champ date \u00ab " + dateIndex + " \u00bb absent";
        }
        String[] temp = new String[maxLength + 1];
        temp[0] = "lang";
        System.arraycopy(fieldLine, 0, temp, 1, maxLength);
        fieldLine = temp;
        try (EditSession editSession = this.bdfServer.initEditSession(this.bdfUser, "ext:Utils/ImportQr");){
            CorpusEditor corpusEditor = editSession.getFichothequeEditor().getCorpusEditor(subsetKey);
            TableIteratorRequestMap mutableRequestMap = new TableIteratorRequestMap(fieldLine);
            for (int i2 = 1; i2 < length; ++i2) {
                int length2;
                String[] ligne = this.checkLine(valeurs[i2]);
                FicheInfo ficheInfo = null;
                if (ligne != null) {
                    ficheInfo = this.getFicheInfo(ligne, idIndex, dateIndex);
                }
                if (ficheInfo == null) {
                    ligne = valeurs[i2];
                    length2 = valeurs[i2].length;
                    for (int j = 0; j < length2; ++j) {
                        System.out.print("|");
                        System.out.print(ligne[j]);
                    }
                    System.out.println("|");
                    ++errorCount;
                    continue;
                }
                length2 = ligne.length;
                String[] temp2 = new String[length2 + 1];
                temp2[0] = "fr";
                System.arraycopy(ligne, 0, temp2, 1, maxLength);
                ligne = temp2;
                mutableRequestMap.updateRow(ligne);
                if (!simulation) {
                    this.resolveRequest(ficheInfo, editSession, corpusEditor, (RequestMap)mutableRequestMap);
                }
                ++count;
            }
            mutableRequestMap.clear();
        }
        StringBuilder buf = new StringBuilder();
        buf.append(count);
        buf.append(" fiches cr\u00e9\u00e9es");
        if (errorCount > 0) {
            buf.append(" / ");
            buf.append(errorCount);
            buf.append(" fiches en erreur");
        }
        return buf.toString();
    }

    private String[] checkLine(String[] line) {
        this.replace(line, 0);
        this.replace(line, 2);
        this.replace(line, 9);
        this.replace(line, 10);
        this.replace(line, 11);
        this.replace(line, 12);
        this.replace(line, 13);
        this.replace(line, 14);
        String date = line[3];
        String iso = this.toIsoString(date);
        if (iso == null) {
            System.out.append("Date Error: " + date);
            return null;
        }
        line[3] = iso;
        return line;
    }

    private void replace(String[] line, int index) {
        String tmp = line[index];
        line[index] = tmp.replace(',', ';');
    }

    private String getCSVString(File file) {
        String string;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        try {
            string = IOUtils.toString((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
        }
        ((Reader)reader).close();
        return string;
    }

    private void resolveRequest(FicheInfo ficheInfo, EditSession editSession, CorpusEditor corpusEditor, RequestMap requestMap) {
        int id = ficheInfo.getId();
        FicheMeta ficheMeta = null;
        if (id != -1) {
            ficheMeta = corpusEditor.getCorpus().getFicheMetaById(id);
        }
        FuzzyDate date = ficheInfo.getDate();
        if (ficheMeta == null) {
            try {
                ficheMeta = corpusEditor.createFiche(id);
                corpusEditor.setDate(ficheMeta, date, false);
            }
            catch (ExistingIdException eie) {
                throw new ShouldNotOccurException("Test done before", (Exception)((Object)eie));
            }
            catch (NoMasterIdException nmie) {
                return;
            }
        } else {
            corpusEditor.setDate(ficheMeta, date, false);
        }
        corpusEditor.setDate(ficheMeta, date, true);
        EditionEngine.update((EditSession)editSession, (BdfParameters)this.bdfParameters, (RequestMap)requestMap, (FicheMeta)ficheMeta);
    }

    private FicheInfo getFicheInfo(String[] ligneArray, int idIndex, int dateIndex) {
        String idString = ligneArray[idIndex];
        boolean error = false;
        int id = -1;
        try {
            id = Integer.parseInt(idString);
        }
        catch (NumberFormatException nfe) {
            System.out.println("Id error: " + idString);
            error = true;
        }
        if (this.idSet.contains(id)) {
            System.out.println("Doublon : " + id);
        }
        this.idSet.add(id);
        String dateString = ligneArray[dateIndex];
        FuzzyDate date = null;
        try {
            date = FuzzyDate.parse((String)dateString);
        }
        catch (ParseException pe) {
            System.out.println("Iso error: " + dateString);
            error = true;
        }
        if (error) {
            return null;
        }
        return new FicheInfo(id, date);
    }

    private String toIsoString(String dateString) {
        Matcher matcher = pattern.matcher(dateString);
        if (!matcher.matches()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String annee = matcher.group(3);
        if (annee.length() == 1) {
            buf.append("200");
        } else if (annee.charAt(0) == '0') {
            buf.append("20");
        } else {
            buf.append("19");
        }
        buf.append(annee);
        buf.append("-");
        String mois = matcher.group(2);
        if (mois.length() == 1) {
            buf.append("0");
        }
        buf.append(mois);
        buf.append("-");
        String jour = matcher.group(1);
        if (jour.length() == 1) {
            buf.append("O");
        }
        buf.append(jour);
        return buf.toString();
    }

    private static class FicheInfo {
        private final int id;
        private final FuzzyDate date;

        private FicheInfo(int id, FuzzyDate date) {
            this.id = id;
            this.date = date;
        }

        private int getId() {
            return this.id;
        }

        private FuzzyDate getDate() {
            return this.date;
        }
    }
}

