/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.comptagen.writers;

import fr.exemole.bdfext.scarabe.api.comptagen.ComptagenLigne;
import fr.exemole.bdfext.scarabe.api.comptagen.ComptagenWriter;
import fr.exemole.bdfext.scarabe.tools.comptagen.ComptagenUtils;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import net.fichotheque.alias.AliasHolder;
import net.mapeadores.util.money.Amount;
import net.mapeadores.util.money.MoneyLong;

public class WinbizComptagenWriter
implements ComptagenWriter {
    private final Appendable appendable;
    private final AliasHolder coreAliasHolder;
    private final int exportFractionDigits;
    private final int maxLength = 60;

    public WinbizComptagenWriter(Appendable appendable, AliasHolder coreAliasHolder, int exportFractionDigits) {
        this.appendable = appendable;
        this.coreAliasHolder = coreAliasHolder;
        this.exportFractionDigits = exportFractionDigits;
    }

    @Override
    public String getCharset() {
        return "UTF-8";
    }

    @Override
    public String getExtension() {
        return ".txt";
    }

    @Override
    public void writeLigne(ComptagenLigne ligne) throws IOException {
        String compteCredit;
        String compteDebit;
        if (ligne.isDebit()) {
            compteDebit = ligne.getNumeroCompte();
            compteCredit = ligne.getNumeroContrepartie();
        } else {
            compteDebit = ligne.getNumeroContrepartie();
            compteCredit = ligne.getNumeroCompte();
        }
        String piece = ligne.getPieceRef();
        LocalDate date = ligne.getDate();
        String montantS = MoneyLong.toString((long)ligne.getExportMoneyLong(), (int)this.exportFractionDigits);
        this.first(WinbizComptagenWriter.toWinbizFormat(date));
        this.next(piece);
        this.next(ComptagenUtils.getShortTitle(ligne, 60));
        this.next(compteDebit);
        this.next(compteCredit);
        this.next(montantS);
        this.next("");
        Amount originalAmount = ligne.getOriginalAmount();
        if (originalAmount != null) {
            this.next(ligne.getConversionRate().toString());
            this.next(originalAmount.toString());
        } else {
            this.next("");
            this.next("");
        }
        this.appendable.append("\n");
    }

    private void first(String s) throws IOException {
        this.appendString(s);
    }

    private void next(String s) throws IOException {
        this.appendable.append(';');
        this.appendString(s);
    }

    private void appendString(String s) throws IOException {
        int length = s.length();
        block4: for (int i = 0; i < length; ++i) {
            char carac = s.charAt(i);
            switch (carac) {
                case '\"': {
                    continue block4;
                }
                case ';': {
                    this.appendable.append(',');
                    continue block4;
                }
                default: {
                    this.appendable.append(carac);
                }
            }
        }
    }

    private static String toWinbizFormat(LocalDate date) {
        return DateTimeFormatter.BASIC_ISO_DATE.format(date);
    }
}

