/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique.recap;

import fr.exemole.bdfext.scarabe.api.analytique.MoneyByCurrency;
import fr.exemole.bdfext.scarabe.api.analytique.Operation;
import fr.exemole.bdfext.scarabe.api.analytique.OperationDef;
import fr.exemole.bdfext.scarabe.api.analytique.SoldeDef;
import fr.exemole.bdfext.scarabe.api.analytique.SoldeOperand;
import fr.exemole.bdfext.scarabe.tools.MutableMoneyByCurrency;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.MandatoryException;

public class OperationBuilder {
    private final OperationDef operationDef;
    private final MutableMoneyByCurrency moneyByCurrency;

    public OperationBuilder(OperationDef operationDef, int currencyLength) {
        this.operationDef = operationDef;
        this.moneyByCurrency = new MutableMoneyByCurrency(currencyLength);
    }

    public OperationDef getOperationDef() {
        return this.operationDef;
    }

    public boolean isRecursive() {
        return this.operationDef.getRecursiveType() != -1;
    }

    public void add(int currencyIndex, long moneyLong) {
        this.moneyByCurrency.add(currencyIndex, moneyLong);
    }

    public void add(MoneyByCurrency other) {
        this.moneyByCurrency.add(other);
    }

    public void add(MoneyByCurrency other, int sign) {
        this.moneyByCurrency.add(other, sign);
    }

    public void addOperation(Operation operation) {
        this.add(operation.getMoneyByCurrency());
    }

    public boolean isSolde() {
        return this.operationDef instanceof SoldeDef;
    }

    public void addToSolde(MoneyByCurrency otherMoneyByCurrency, SoldeOperand soldeOperand) throws MandatoryException {
        if (otherMoneyByCurrency == null || otherMoneyByCurrency.isEmpty()) {
            if (soldeOperand.isMandatory()) {
                throw new MandatoryException();
            }
            return;
        }
        this.add(otherMoneyByCurrency, soldeOperand.getSign());
    }

    public void addToSolde(OperationBuilder other, SoldeOperand soldeOperand) throws MandatoryException {
        this.addToSolde(other.moneyByCurrency, soldeOperand);
    }

    public Operation toOperation() {
        return new InternalOperation(this.operationDef, this.moneyByCurrency);
    }

    private static class InternalOperation
    implements Operation {
        private final OperationDef operationDef;
        private final MoneyByCurrency moneyByCurrency;

        private InternalOperation(OperationDef operationDef, MoneyByCurrency moneyByCurrency) {
            this.operationDef = operationDef;
            this.moneyByCurrency = moneyByCurrency;
        }

        @Override
        public OperationDef getOperationDef() {
            return this.operationDef;
        }

        @Override
        public MoneyByCurrency getMoneyByCurrency() {
            return this.moneyByCurrency;
        }
    }
}

