/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique;

import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDef;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueItem;
import fr.exemole.bdfext.scarabe.api.core.LigneHolder;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueGatheringBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueItemBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.GroupbyEngine;
import fr.exemole.bdfext.scarabe.tools.analytique.PopulateEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetItem;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.include.IncludeMode;
import net.fichotheque.junction.Junctions;
import net.fichotheque.junction.Liaison;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.pointeurs.MotclePointeur;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.utils.JunctionUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.money.Currencies;

public class AnalytiqueItemEngine
extends PopulateEngine {
    private static final SubCorpusInfo[] EMPTY_SUBCORPUSINFOARRAY = new SubCorpusInfo[0];
    private final AnalytiqueDef analytiqueDef;
    private final SubCorpusInfo[] subCorpusInfoArray;
    private final GroupbyEngine groupbyEngine;

    public AnalytiqueItemEngine(AliasHolder coreAliasHolder, LigneHolder ligneHolder, Currencies currencyHolder, AnalytiqueDef analytiqueDef) {
        super(coreAliasHolder, ligneHolder, currencyHolder);
        this.analytiqueDef = analytiqueDef;
        List<IncludeKey> subIncludeKeyList = analytiqueDef.getSubIncludeKeyList();
        if (subIncludeKeyList.isEmpty()) {
            this.subCorpusInfoArray = EMPTY_SUBCORPUSINFOARRAY;
        } else {
            Fichotheque fichotheque = coreAliasHolder.getCorpus("depense").getFichotheque();
            ArrayList<SubCorpusInfo> subCorpusList = new ArrayList<SubCorpusInfo>();
            for (IncludeKey subCorpusIncludeKey : subIncludeKeyList) {
                Corpus corpus = (Corpus)fichotheque.getSubset(subCorpusIncludeKey.getSubsetKey());
                if (corpus == null) continue;
                FichePointeur fichePointeur = PointeurFactory.newFichePointeur((Corpus)corpus);
                subCorpusList.add(new SubCorpusInfo(subCorpusIncludeKey, fichePointeur));
            }
            this.subCorpusInfoArray = subCorpusList.toArray(new SubCorpusInfo[subCorpusList.size()]);
        }
        this.groupbyEngine = GroupbyEngine.newInstance(analytiqueDef, coreAliasHolder, ligneHolder, currencyHolder);
    }

    public AnalytiqueItem build(FichePointeur pointeur) {
        AnalytiqueGatheringBuilder analytiqueGatheringBuilder = AnalytiqueGatheringBuilder.buildForAnalytiqueItem(this.analytiqueDef.getOperationDefList().size());
        AnalytiqueItemBuilder analytiqueItemBuilder = new AnalytiqueItemBuilder(pointeur.getCurrentSubsetItem(), analytiqueGatheringBuilder);
        if (this.groupbyEngine != null) {
            this.groupbyEngine.populate((SubsetItemPointeur)pointeur, analytiqueItemBuilder);
        } else {
            this.populateLignes((SubsetItemPointeur)pointeur, analytiqueGatheringBuilder);
        }
        this.populateAgregat((SubsetItemPointeur)pointeur, analytiqueGatheringBuilder);
        return analytiqueItemBuilder.toAnalytiqueItem();
    }

    public AnalytiqueItem build(MotclePointeur pointeur) {
        AnalytiqueGatheringBuilder analytiqueGatheringBuilder = AnalytiqueGatheringBuilder.buildForAnalytiqueItem(this.analytiqueDef.getOperationDefList().size());
        Motcle motcle = (Motcle)pointeur.getCurrentSubsetItem();
        AnalytiqueItemBuilder analytiqueItemBuilder = new AnalytiqueItemBuilder(pointeur.getCurrentSubsetItem(), analytiqueGatheringBuilder);
        if (this.groupbyEngine != null) {
            this.groupbyEngine.populate((SubsetItemPointeur)pointeur, analytiqueItemBuilder);
        } else {
            this.populateLignes((SubsetItemPointeur)pointeur, analytiqueGatheringBuilder);
        }
        this.populateAgregat((SubsetItemPointeur)pointeur, analytiqueGatheringBuilder);
        this.populateSubCorpus((SubsetItemPointeur)pointeur, analytiqueItemBuilder);
        List motcleList = motcle.getChildList();
        if (!motcleList.isEmpty()) {
            for (Motcle child : motcleList) {
                pointeur.setCurrentSubsetItem((SubsetItem)child);
                analytiqueItemBuilder.addChild(this.build(pointeur));
            }
        }
        return analytiqueItemBuilder.toAnalytiqueItem();
    }

    private void populateSubCorpus(SubsetItemPointeur analytiqueItemPointeur, AnalytiqueItemBuilder analytiqueItemBuilder) {
        for (SubCorpusInfo subCorpusInfo : this.subCorpusInfoArray) {
            FichePointeur subCorpusFichePointeur = subCorpusInfo.fichePointeur;
            Junctions junctions = analytiqueItemPointeur.getJunctions(subCorpusFichePointeur.getSubset());
            IncludeKey includeKey = subCorpusInfo.includeKey;
            Collection liaisons = JunctionUtils.filter((Junctions)junctions, (IncludeMode)includeKey);
            for (Liaison liaison : liaisons) {
                subCorpusFichePointeur.setCurrentSubsetItem(liaison.getSubsetItem());
                AnalytiqueGatheringBuilder analytiqueGatheringBuilder = AnalytiqueGatheringBuilder.buildForSubCorpus(this.analytiqueDef.getOperationDefList().size(), includeKey);
                this.populateLignes((SubsetItemPointeur)subCorpusFichePointeur, analytiqueGatheringBuilder);
                this.populateAgregat((SubsetItemPointeur)subCorpusFichePointeur, analytiqueGatheringBuilder);
                analytiqueItemBuilder.addSubCorpus(AnalytiqueUtils.toSubCorpus((FicheMeta)subCorpusFichePointeur.getCurrentSubsetItem(), analytiqueGatheringBuilder.toAnalytiqueGathering()));
            }
        }
    }

    private void populateAgregat(SubsetItemPointeur pointeur, AnalytiqueGatheringBuilder analytiqueGatheringBuilder) {
        this.populateAgregat(this.analytiqueDef, pointeur, analytiqueGatheringBuilder, this.currencies);
    }

    private static class SubCorpusInfo {
        public IncludeKey includeKey;
        public FichePointeur fichePointeur;

        private SubCorpusInfo(IncludeKey includeKey, FichePointeur fichePointeur) {
            this.includeKey = includeKey;
            this.fichePointeur = fichePointeur;
        }
    }
}

