/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.ScarabeLocalisation;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDetails;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueRecap;
import fr.exemole.bdfext.scarabe.api.analytique.ItemAnalytiqueDetails;
import fr.exemole.bdfext.scarabe.api.core.BanqueDetail;
import fr.exemole.bdfext.scarabe.api.exportation.ScarabeTableWriter;
import fr.exemole.bdfext.scarabe.producers.stream.TableEngineOdsProducer;
import fr.exemole.bdfext.scarabe.tools.exportation.TableEngine;
import fr.exemole.bdfext.scarabe.tools.exportation.analytique.AnalytiqueDetailTableEngine;
import fr.exemole.bdfext.scarabe.tools.exportation.analytique.AnalytiqueRecapTableEngine;
import fr.exemole.bdfext.scarabe.tools.exportation.analytique.TableaucroiseTableEngine;
import fr.exemole.bdfext.scarabe.tools.exportation.banque.GeneralTableEngine;
import fr.exemole.bdfext.scarabe.tools.exportation.banque.LigneTableEngine;
import fr.exemole.bdfext.scarabe.tools.exportation.banque.MouvementTableEngine;
import fr.exemole.bdfext.scarabe.tools.exportation.banque.RecapitulatifTableEngine;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.providers.StreamProducerProvider;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.text.ParseException;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.opendocument.io.SheetWriter;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.opendocument.io.odtable.OdTableDefBuilder;
import net.mapeadores.util.date.DateUtils;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class ScarabeStreamProducerProvider
implements StreamProducerProvider {
    private final ScarabeContext scarabeContext;

    public ScarabeStreamProducerProvider(ScarabeContext scarabeContext) {
        this.scarabeContext = scarabeContext;
    }

    public StreamProducer getStreamProducer(OutputParameters parameters) throws ErrorMessageException {
        if (this.scarabeContext.getInitState() != 1) {
            return null;
        }
        if (!BdfInstructionUtils.ownsToExtension((OutputParameters)parameters, (String)"scarabe")) {
            return null;
        }
        BdfServer bdfServer = parameters.getBdfServer();
        String stream = parameters.getOutput();
        BdfUser bdfUser = parameters.getBdfUser();
        RequestMap requestMap = parameters.getRequestMap();
        ScarabeLocalisation scarabeLocalisation = ScarabeLocalisation.build((BdfParameters)parameters);
        SheetWriter supplementarySheetWriter = BdfUserUtils.getSupplementarySheetWriter((BdfParameters)parameters);
        switch (stream) {
            case "BanqueDetailTable.ods": {
                bdfUser.putParameter("scarabe.lastbanquedetailformat", (Object)"ods");
                BanqueDetail banqueDetail = (BanqueDetail)parameters.getResultObject("scarabe.obj_banquedetail");
                String type = (String)parameters.getResultObject("scarabe.obj_type");
                if (banqueDetail == null) {
                    return ScarabeStreamProducerProvider.getErrorOdsProducer(scarabeLocalisation, supplementarySheetWriter);
                }
                StringBuilder buf = new StringBuilder();
                buf.append("banque");
                buf.append("-");
                buf.append(banqueDetail.getBanque().getCodeBanque());
                buf.append("-");
                buf.append(type);
                buf.append(".");
                buf.append(DateUtils.isoNow());
                buf.append(".ods");
                TableEngine tableEngine = ScarabeStreamProducerProvider.initBanqueDetailTableEngine((BdfParameters)parameters, this.scarabeContext, banqueDetail, type);
                return new TableEngineOdsProducer(buf.toString(), tableEngine, supplementarySheetWriter);
            }
            case "AnalytiqueDetailTable.ods": {
                bdfUser.putParameter("scarabe.lastanalytiquedetailformat", (Object)"ods");
                AnalytiqueDetails analytiqueDetails = (AnalytiqueDetails)parameters.getResultObject("scarabe.obj_analytiquedetails");
                AnalytiqueRecap analytiqueRecap = (AnalytiqueRecap)parameters.getResultObject("scarabe.obj_analytiquerecap");
                if (analytiqueDetails == null) {
                    return ScarabeStreamProducerProvider.getErrorOdsProducer(scarabeLocalisation, supplementarySheetWriter);
                }
                StringBuilder buf = new StringBuilder();
                buf.append(analytiqueDetails.getAnalytiqueSubset().getSubset().getSubsetKeyString());
                if (analytiqueDetails instanceof ItemAnalytiqueDetails) {
                    buf.append("-");
                    buf.append(((ItemAnalytiqueDetails)analytiqueDetails).getAnalytiqueItem().getSubsetItem().getId());
                }
                buf.append(".");
                buf.append(DateUtils.isoNow());
                buf.append(".ods");
                AnalytiqueDetailTableEngine tableEngine = new AnalytiqueDetailTableEngine(analytiqueDetails, (BdfParameters)parameters, scarabeLocalisation, analytiqueRecap, this.scarabeContext);
                return new TableEngineOdsProducer(buf.toString(), tableEngine, supplementarySheetWriter);
            }
            case "AnalytiqueRecapList.ods": {
                AnalytiqueRecap analytiqueRecap = (AnalytiqueRecap)parameters.getResultObject("scarabe.obj_analytiquerecap");
                if (analytiqueRecap == null) {
                    return ScarabeStreamProducerProvider.getErrorOdsProducer(scarabeLocalisation, supplementarySheetWriter);
                }
                StringBuilder buf = new StringBuilder();
                buf.append(analytiqueRecap.getAnalytiqueParameters().getAnalytiqueSubset().getSubsetKey());
                buf.append(".");
                buf.append(DateUtils.isoNow());
                buf.append(".ods");
                AnalytiqueRecapTableEngine tableEngine = new AnalytiqueRecapTableEngine(analytiqueRecap, scarabeLocalisation);
                return new TableEngineOdsProducer(buf.toString(), tableEngine, supplementarySheetWriter);
            }
            case "BanqueRecapitulatif.ods": {
                StringBuilder buf = new StringBuilder();
                buf.append("banquerecap");
                buf.append(".");
                buf.append(DateUtils.isoNow());
                buf.append(".ods");
                RecapitulatifTableEngine tableEngine = new RecapitulatifTableEngine(this.scarabeContext.getScarabeCache().getRecapitulatif(bdfServer), scarabeLocalisation);
                return new TableEngineOdsProducer(buf.toString(), tableEngine, supplementarySheetWriter);
            }
            case "TableaucroiseTable.ods": {
                bdfUser.putParameter("scarabe.lasttableaucroiseformat", (Object)"ods");
                AnalytiqueDetails analytiqueDetails = (AnalytiqueDetails)parameters.getResultObject("scarabe.obj_analytiquedetails");
                if (analytiqueDetails == null) {
                    return ScarabeStreamProducerProvider.getErrorOdsProducer(scarabeLocalisation, supplementarySheetWriter);
                }
                Fichotheque fichotheque = bdfServer.getFichotheque();
                IncludeKey includeKey = ScarabeStreamProducerProvider.initIncludeKey(requestMap, fichotheque);
                if (includeKey == null) {
                    return ScarabeStreamProducerProvider.getErrorOdsProducer(scarabeLocalisation, supplementarySheetWriter);
                }
                List<Motcle> motcleList = ScarabeStreamProducerProvider.initMotcleList(requestMap, fichotheque, includeKey);
                StringBuilder buf = new StringBuilder();
                buf.append(analytiqueDetails.getAnalytiqueSubset().getSubset().getSubsetKeyString());
                buf.append("-");
                buf.append(includeKey);
                if (analytiqueDetails instanceof ItemAnalytiqueDetails) {
                    buf.append("-");
                    buf.append(((ItemAnalytiqueDetails)analytiqueDetails).getAnalytiqueItem());
                }
                buf.append(".");
                buf.append(DateUtils.isoNow());
                buf.append(".ods");
                TableaucroiseTableEngine tableEngine = new TableaucroiseTableEngine(analytiqueDetails, scarabeLocalisation, includeKey, motcleList);
                return new TableEngineOdsProducer(buf.toString(), tableEngine, supplementarySheetWriter);
            }
        }
        return null;
    }

    private static TableEngine initBanqueDetailTableEngine(BdfParameters bdfParameters, ScarabeContext scarabeContext, BanqueDetail banqueDetail, String type) {
        ScarabeLocalisation scarabeLocalisation = ScarabeLocalisation.build(bdfParameters);
        TableEngine tableEngine = null;
        if (banqueDetail != null) {
            if (type != null) {
                if (type.equals("ligne")) {
                    tableEngine = new LigneTableEngine(banqueDetail, scarabeLocalisation);
                } else if (type.equals("general")) {
                    tableEngine = new GeneralTableEngine(banqueDetail, bdfParameters, scarabeLocalisation, scarabeContext);
                }
            }
            if (tableEngine == null) {
                tableEngine = new MouvementTableEngine(banqueDetail, scarabeLocalisation);
            }
        }
        return tableEngine;
    }

    private static StreamProducer getErrorOdsProducer(ScarabeLocalisation scarabeLocalisation, SheetWriter supplementarySheetWriter) {
        StringBuilder buf = new StringBuilder();
        buf.append("parameter_error");
        buf.append(".ods");
        ErrorTableEngine tableEngine = new ErrorTableEngine(scarabeLocalisation);
        return new TableEngineOdsProducer(buf.toString(), tableEngine, supplementarySheetWriter);
    }

    private static IncludeKey initIncludeKey(RequestMap requestMap, Fichotheque fichotheque) {
        String includeKeyString = requestMap.getParameter("includekey");
        if (includeKeyString == null) {
            return null;
        }
        try {
            IncludeKey includeKey = IncludeKey.parse((String)includeKeyString);
            SubsetKey subsetKey = includeKey.getSubsetKey();
            if (subsetKey.isThesaurusSubset() && fichotheque.containsSubset(subsetKey)) {
                return includeKey;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    private static List<Motcle> initMotcleList(RequestMap requestMap, Fichotheque fichotheque, IncludeKey includeKey) {
        Thesaurus thesaurus = (Thesaurus)fichotheque.getSubset(includeKey.getSubsetKey());
        return ThesaurusUtils.toHierarchicMotcleList((Thesaurus)thesaurus);
    }

    private static class ErrorTableEngine
    extends TableEngine {
        private final OdTableDef odTableDef = OdTableDefBuilder.init((String)"").addStandard().toOdTableDef();
        private final String title;

        private ErrorTableEngine(ScarabeLocalisation scarabeLocalisation) {
            super(scarabeLocalisation);
            this.title = "error";
        }

        @Override
        public OdTableDef getOdTableDef() {
            return this.odTableDef;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public void writeHead(ScarabeTableWriter tableWriter) {
        }

        @Override
        public void writeBody(ScarabeTableWriter tableWriter) {
            tableWriter.startRow();
            tableWriter.addStringCell("Request parameter error");
            tableWriter.endRow();
        }
    }
}

