/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import net.mapeadores.util.date.FuzzyDateFormatter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.UserLangContext;

public class ScarabeLocalisation {
    private final UserLangContext userLangContext;
    private final MessageLocalisation messageLocalisation;
    private final DateTimeFormatter mediumDateFormatter;

    public ScarabeLocalisation(UserLangContext userLangContext, MessageLocalisation messageLocalisation) {
        this.userLangContext = userLangContext;
        this.messageLocalisation = messageLocalisation;
        this.mediumDateFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(userLangContext.getFormatLocale());
    }

    public UserLangContext getUserLangContext() {
        return this.userLangContext;
    }

    public Lang getWorkingLang() {
        return this.userLangContext.getWorkingLang();
    }

    public MessageLocalisation getMessageLocalisation() {
        return this.messageLocalisation;
    }

    public Locale getFormatLocale() {
        return this.userLangContext.getFormatLocale();
    }

    public DateTimeFormatter getMediumDateFormatter() {
        return this.mediumDateFormatter;
    }

    public FuzzyDateFormatter getLongFuzzyDateFormatter() {
        return FuzzyDateFormatter.build((FormatStyle)FormatStyle.LONG, (Locale)this.userLangContext.getFormatLocale());
    }

    public static ScarabeLocalisation build(BdfParameters bdfParameters) {
        MessageLocalisation messageLocalisation = bdfParameters.getMessageLocalisation();
        return new ScarabeLocalisation(bdfParameters.getUserLangContext(), messageLocalisation);
    }
}

