/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.xml.api;

import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.AtlasEditor;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.metadata.AtlasAttributeDefList;
import net.desmodo.atlas.metadata.AtlasMetadataEditor;
import net.desmodo.atlas.xml.api.AtlasDOMErrorHandler;
import net.desmodo.atlas.xml.api.AttributeDOMReader;
import net.mapeadores.util.attr.AttributeDef;
import net.mapeadores.util.attr.AttributeDefBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.CheckedLocalKey;
import net.mapeadores.util.attr.CheckedNameSpace;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class MetadataDOMReader {
    private final AtlasDOMErrorHandler errorHandler;
    private final AtlasMetadataEditor metadataEditor;
    private final AttributeDOMReader attributeDOMReader;
    private String xpath;
    private final AtlasEditor atlasEditor;
    private boolean withLang = false;
    private AtlasAttributeDefListBuilder atlasAttributeDefListBuilder;

    public MetadataDOMReader(AtlasEditor atlasEditor, AtlasDOMErrorHandler errorHandler) {
        this.metadataEditor = atlasEditor.getAtlasMetaDataEditor();
        this.errorHandler = errorHandler;
        this.attributeDOMReader = new AttributeDOMReader(atlasEditor, errorHandler);
        this.atlasEditor = atlasEditor;
    }

    public void readMetadataElement(Element element, String xpath) {
        this.xpath = xpath;
        this.atlasAttributeDefListBuilder = new AtlasAttributeDefListBuilder();
        DOMUtils.readChildren((Element)element, (Consumer)new MetadataConsumer());
        AtlasAttributeDefList defList = this.atlasAttributeDefListBuilder.toAtlasAttributeDefList();
        if (defList.getAttributeDefCount() != 0 || defList.getInactiveAttributeKeyCount() != 0) {
            this.metadataEditor.setAtlasAttributeDefList(defList);
        }
    }

    public boolean isWithLang() {
        return this.withLang;
    }

    private class AtlasAttributeDefListBuilder {
        private final Map<AttributeKey, AttributeDef> map = new LinkedHashMap<AttributeKey, AttributeDef>();
        private final Set<AttributeKey> inactiveSet = new LinkedHashSet<AttributeKey>();

        private AtlasAttributeDefListBuilder() {
        }

        private void addAttributeDef(AttributeDef attributeDef) {
            AttributeKey attributeKey = attributeDef.getAttributeKey();
            this.map.put(attributeKey, attributeDef);
            this.inactiveSet.remove(attributeKey);
        }

        private void addInactive(AttributeKey attributeKey) {
            this.inactiveSet.add(attributeKey);
            this.map.remove(attributeKey);
        }

        private AtlasAttributeDefList toAtlasAttributeDefList() {
            int attributeDefSize = this.map.size();
            AttributeDef[] attributeDefArray = new AttributeDef[attributeDefSize];
            if (attributeDefSize > 0) {
                int p = 0;
                Iterator<AttributeDef> iterator = this.map.values().iterator();
                while (iterator.hasNext()) {
                    AttributeDef attributeDef;
                    attributeDefArray[p] = attributeDef = iterator.next();
                    ++p;
                }
            }
            int inactiveSize = this.inactiveSet.size();
            AttributeKey[] inactiveArray = new AttributeKey[inactiveSize];
            if (inactiveSize > 0) {
                int p = 0;
                Iterator<AttributeKey> iterator = this.inactiveSet.iterator();
                while (iterator.hasNext()) {
                    AttributeKey attributeKey;
                    inactiveArray[p] = attributeKey = iterator.next();
                    ++p;
                }
            }
            return new InternalAtlasAttributeDefList(attributeDefArray, inactiveArray);
        }

        private class InternalAtlasAttributeDefList
        implements AtlasAttributeDefList {
            private final AttributeDef[] attributeDefArray;
            private final AttributeKey[] inactiveArray;

            private InternalAtlasAttributeDefList(AttributeDef[] attributeDefArray, AttributeKey[] inactiveArray) {
                this.attributeDefArray = attributeDefArray;
                this.inactiveArray = inactiveArray;
            }

            @Override
            public int getAttributeDefCount() {
                return this.attributeDefArray.length;
            }

            @Override
            public AttributeDef getAttributeDef(int i) {
                return this.attributeDefArray[i];
            }

            @Override
            public int getInactiveAttributeKeyCount() {
                return this.inactiveArray.length;
            }

            @Override
            public AttributeKey getInactiveAttributeKey(int i) {
                return this.inactiveArray[i];
            }
        }
    }

    private class MetadataConsumer
    implements Consumer<Element> {
        private MetadataConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("titre")) {
                DOMUtils.readChildren((Element)element, (Consumer)new TitreConsumer());
            } else if (tagName.equals("langs")) {
                LangsConsumer langsConsumer = new LangsConsumer();
                DOMUtils.readChildren((Element)element, (Consumer)langsConsumer);
                Langs langs = langsConsumer.toLangs();
                if (langs.size() > 0) {
                    MetadataDOMReader.this.metadataEditor.setWorkingLangs(langs);
                    MetadataDOMReader.this.withLang = true;
                }
            } else if (tagName.equals("attr")) {
                MetadataDOMReader.this.attributeDOMReader.readAttrElement(element, MetadataDOMReader.this.metadataEditor.getAtlasMetadata(), MetadataDOMReader.this.xpath);
            } else if (tagName.equals("attr-def")) {
                CheckedLocalKey localKey;
                CheckedNameSpace nameSpace;
                String nameSpaceString = element.getAttribute("ns");
                if (nameSpaceString.length() == 0) {
                    MetadataDOMReader.this.errorHandler.missingAttributeError("ns", MetadataDOMReader.this.xpath + "/attr-def");
                    return;
                }
                String localKeyString = element.getAttribute("key");
                if (localKeyString.length() == 0) {
                    MetadataDOMReader.this.errorHandler.missingAttributeError("key", MetadataDOMReader.this.xpath + "/attr-def");
                    return;
                }
                try {
                    nameSpace = CheckedNameSpace.parse((CharSequence)nameSpaceString);
                }
                catch (ParseException pe) {
                    MetadataDOMReader.this.errorHandler.wrongAttributeError("ns", nameSpaceString, "Malformed", MetadataDOMReader.this.xpath + "/attr-def");
                    return;
                }
                try {
                    localKey = CheckedLocalKey.parse((CharSequence)localKeyString);
                }
                catch (ParseException pe) {
                    MetadataDOMReader.this.errorHandler.wrongAttributeError("key", localKeyString, "Malformed", MetadataDOMReader.this.xpath + "/attr-def");
                    return;
                }
                AttributeKey attributeKey = AttributeKey.build((CheckedNameSpace)nameSpace, (CheckedLocalKey)localKey);
                String activeString = element.getAttribute("active");
                if (activeString.equals("0")) {
                    MetadataDOMReader.this.atlasAttributeDefListBuilder.addInactive(attributeKey);
                } else {
                    AttributeDefHandler attributeDefHandler = new AttributeDefHandler(attributeKey);
                    DOMUtils.readChildren((Element)element, (Consumer)attributeDefHandler);
                    MetadataDOMReader.this.atlasAttributeDefListBuilder.addAttributeDef(attributeDefHandler.toAttributeDef());
                }
            } else {
                MetadataDOMReader.this.errorHandler.unknownTagWarning(tagName, MetadataDOMReader.this.xpath);
            }
        }
    }

    private class AttributeDefHandler
    implements Consumer<Element> {
        private final AttributeKey attributeKey;
        private final AttributeDefBuilder builder;

        private AttributeDefHandler(AttributeKey attributeKey) {
            this.attributeKey = attributeKey;
            this.builder = new AttributeDefBuilder(attributeKey);
        }

        @Override
        public void accept(Element element) {
            String scope;
            String tagName = element.getTagName();
            if (tagName.equals("lib")) {
                try {
                    Label libelle = LabelUtils.readLabel((Element)element);
                    if (libelle != null) {
                        this.builder.putLabel(libelle);
                    }
                }
                catch (ParseException lie) {
                    MetadataDOMReader.this.errorHandler.libLangAttributeError(element.getAttribute("xml:lang"), MetadataDOMReader.this.xpath + "/attr-def/lib");
                }
            } else if (tagName.equals("format")) {
                String type = element.getAttribute("type");
                this.builder.putDefObject("format_type", (Object)type);
            } else if (tagName.equals("scope") && (scope = DOMUtils.readSimpleElement((Element)element)).length() > 0) {
                this.builder.getAttributesBuilder().appendValue(AtlasAttributes.SCOPE_KEY, scope);
            }
        }

        public AttributeDef toAttributeDef() {
            return this.builder.toAttributeDef();
        }
    }

    private class LangsConsumer
    implements Consumer<Element> {
        private final Set<Lang> langSet = new LinkedHashSet<Lang>();

        private LangsConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("lang")) {
                String langString = DOMUtils.readSimpleElement((Element)element);
                if (langString.length() == 0) {
                    MetadataDOMReader.this.errorHandler.emptyElementError(MetadataDOMReader.this.xpath + "/langs/lang");
                    return;
                }
                try {
                    Lang langInteger = Lang.parse((String)langString);
                    this.langSet.add(langInteger);
                }
                catch (ParseException pe) {
                    MetadataDOMReader.this.errorHandler.wrongElementContentError(langString, "badLangCode", MetadataDOMReader.this.xpath + "/langs/lang");
                }
            } else {
                MetadataDOMReader.this.errorHandler.unknownTagWarning(tagName, MetadataDOMReader.this.xpath + "/langs");
            }
        }

        public Langs toLangs() {
            return LangsUtils.fromCollection(this.langSet);
        }
    }

    private class TitreConsumer
    implements Consumer<Element> {
        private TitreConsumer() {
        }

        @Override
        public void accept(Element element) {
            Term titre = MetadataDOMReader.this.metadataEditor.getAtlasMetadata().getTitre();
            String tagName = element.getTagName();
            if (tagName.equals("lib")) {
                try {
                    Label libelle = LabelUtils.readLabel((Element)element);
                    if (libelle != null) {
                        MetadataDOMReader.this.atlasEditor.putLibelle(titre, libelle);
                    }
                }
                catch (ParseException lie) {
                    MetadataDOMReader.this.errorHandler.libLangAttributeError(element.getAttribute("xml:lang"), MetadataDOMReader.this.xpath + "/titre/lib");
                }
            } else if (tagName.equals("attr")) {
                MetadataDOMReader.this.attributeDOMReader.readAttrElement(element, titre, MetadataDOMReader.this.xpath + "/titre");
            } else {
                MetadataDOMReader.this.errorHandler.unknownTagWarning(tagName, MetadataDOMReader.this.xpath + "/titre");
            }
        }
    }
}

