/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.wrapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.AtlasUtils;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.GrilleList;
import net.desmodo.atlas.structure.Structure;
import net.desmodo.atlas.structure.StructureUtils;
import net.desmodo.atlas.tools.multilist.MultiList;
import net.desmodo.atlas.tools.multilist.MultiListItem;
import net.desmodo.atlas.wrapper.AbstractComboBoxModel;
import net.desmodo.atlas.wrapper.GroupeItemImpl;
import net.desmodo.atlas.wrapper.GroupeItemManager;
import net.mapeadores.util.localisation.Lang;

class GroupeItemManagerImpl
implements GroupeItemManager {
    static final int SECONDARYINDEX_COUNT = 10;
    static final int TYPE_COUNT = 10;
    static final int[] listModelIndexByType = new int[10];
    static final int[] listModelMaskByType;
    static final short OBJECT_REMOVED = 1;
    static final short OBJECT_ADDED = 2;
    static final short OBJECT_CHANGED = 3;
    static final short OBJECT_TRANSLATED = 4;
    private Map<Integer, GroupeItemImpl> internalGroupeItemMap = new HashMap<Integer, GroupeItemImpl>();
    private GroupeItemImpl sansfamilleGroupeItem;
    private Lang workingLang;
    private MultiList multiList = new MultiList(10);
    private GroupeItemListModel[] listModels = new GroupeItemListModel[10];

    GroupeItemManagerImpl(Atlas atlas, Lang workingLang) {
        this.listModels[0] = new GroupeItemListModel(0);
        this.listModels[1] = new GroupeItemListModel(1);
        this.listModels[2] = new GroupeItemListModel(2);
        this.listModels[3] = new GroupeItemListModel(3);
        this.listModels[4] = new GroupeItemListModel(4);
        this.listModels[5] = new GroupeItemListModel(5);
        this.listModels[6] = new GroupeItemListModel(6);
        this.listModels[7] = new GroupeItemListModel(7);
        this.listModels[8] = new GroupeItemListModel(8);
        this.listModels[9] = new GroupeItemListModel(9);
        this.reinit(atlas, workingLang);
    }

    @Override
    public ComboBoxModel getGroupeItemListModel(short type) {
        if (type < 0 || type >= 10) {
            throw new IllegalArgumentException("wrong type value");
        }
        return this.listModels[type];
    }

    private void reinit(Atlas atlas, Lang workingLang) {
        this.workingLang = workingLang;
        Structure structure = atlas.getStructure();
        Contexte sansfamille = StructureUtils.getSansfamilleContexte(structure);
        this.sansfamilleGroupeItem = this.initInternalGroupeItem(sansfamille, GroupeItemManagerImpl.getSansfamilleInitialMask(sansfamille), null);
        ContexteList famillesList = structure.getGrilleDesFamilles().getFirstLevelContexteList();
        int familleCount = famillesList.getContexteCount();
        for (int i = 0; i < familleCount; ++i) {
            this.initFamille(famillesList.getContexte(i), this.sansfamilleGroupeItem);
        }
        GrilleList grilleList = structure.getGrilleList();
        int grilleCount = grilleList.getGrilleCount();
        for (int i = 0; i < grilleCount; ++i) {
            this.initGrille(grilleList.getGrille(i));
        }
    }

    public Lang getWorkingLang() {
        return this.workingLang;
    }

    GroupeItemImpl getInternalGroupeItem(Term term) {
        return this.internalGroupeItemMap.get(term.getCode());
    }

    GroupeItemImpl getInternalGroupeItem(int code) {
        return this.internalGroupeItemMap.get(code);
    }

    GroupeItemImpl getInternalGroupeItemParent(Descripteur descripteur) {
        GroupeItemImpl internalGroupeItem = this.getInternalGroupeItem(descripteur.getFamille());
        if (internalGroupeItem == null) {
            throw new IllegalStateException("groupeItemMissing : Il n'y a pas de GroupeItem pour le contexte demand\u00e9");
        }
        return internalGroupeItem;
    }

    GroupeItemImpl getInternalGroupeItemParent(Contexte contexte) {
        Contexte parent = contexte.getParent();
        if (parent != null) {
            GroupeItemImpl internalGroupeItem = this.getInternalGroupeItem(parent);
            if (internalGroupeItem == null) {
                throw new IllegalStateException("groupeItemMissing : Il n'y a pas de GroupeItem pour le contexte demand\u00e9");
            }
            return internalGroupeItem;
        }
        GroupeItemImpl internalGroupeItem = this.getInternalGroupeItem(contexte.getGrille());
        if (internalGroupeItem == null) {
            throw new IllegalStateException("groupeItemMissing : Il n'y a pas de GroupeItem pour le contexte demand\u00e9");
        }
        return internalGroupeItem;
    }

    private void initFamille(Contexte famille, GroupeItemImpl parent) {
        GroupeItemImpl internalGroupeItem = this.initInternalGroupeItem(famille, GroupeItemManagerImpl.getFamilleInitialMask(famille), parent);
        ContexteList contexteList = famille.getChildren();
        int contexteCount = contexteList.getContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            this.initFamille(contexteList.getContexte(i), internalGroupeItem);
        }
    }

    private void initGrille(Grille grille) {
        GroupeItemImpl internalGroupeItem = this.initInternalGroupeItem(grille, GroupeItemManagerImpl.getInitialMask(grille), null);
        ContexteList contexteList = grille.getFirstLevelContexteList();
        int contexteCount = contexteList.getContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            this.initContexte(contexteList.getContexte(i), internalGroupeItem);
        }
    }

    private void initContexte(Contexte contexte, GroupeItemImpl parent) {
        GroupeItemImpl internalGroupeItem = this.initInternalGroupeItem(contexte, GroupeItemManagerImpl.getInGrilleContexteInitialMask(contexte), parent);
        ContexteList contexteList = contexte.getChildren();
        int contexteCount = contexteList.getContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            this.initContexte(contexteList.getContexte(i), internalGroupeItem);
        }
    }

    private GroupeItemImpl initInternalGroupeItem(Term term, int initialMask, GroupeItemImpl parent) {
        GroupeItemImpl internalGroupeItem = new GroupeItemImpl(this, term, initialMask, parent);
        int[] array = internalGroupeItem.getSecondaryIndex();
        new Change(2, array);
        this.internalGroupeItemMap.put(internalGroupeItem.getTermCode(), internalGroupeItem);
        return internalGroupeItem;
    }

    MultiList getInternalGroupeItemMultiList() {
        return this.multiList;
    }

    private void removeInternalGroupeItem(GroupeItemImpl internalGroupeItem) {
        int[] array = internalGroupeItem.getSecondaryIndex();
        this.multiList.remove(internalGroupeItem);
        this.internalGroupeItemMap.remove(internalGroupeItem.getTermCode());
        new Change(1, array);
    }

    private GroupeItemImpl getParent(Contexte contexte) {
        Contexte contexteParent = contexte.getParent();
        GroupeItemImpl newParent = null;
        newParent = contexteParent == null ? (StructureUtils.isFamille(contexte) ? this.sansfamilleGroupeItem : this.getInternalGroupeItem(contexte.getGrille())) : this.getInternalGroupeItem(contexteParent);
        return newParent;
    }

    void grilleCreated(Grille grille) {
        int mask = GroupeItemManagerImpl.getInitialMask(grille);
        this.initInternalGroupeItem(grille, mask, null);
    }

    void contexteCreated(Contexte contexte) {
        boolean isFamille = contexte.getTermType() == 4;
        int mask = 0;
        GroupeItemImpl parent = null;
        if (isFamille) {
            mask = GroupeItemManagerImpl.getFamilleInitialMask(contexte);
            parent = this.sansfamilleGroupeItem;
        } else {
            mask = GroupeItemManagerImpl.getInGrilleContexteInitialMask(contexte);
            parent = this.getInternalGroupeItem(contexte.getGrille());
        }
        List<GroupeItemImpl> branchList = this.getBranchList(parent);
        GroupeItemImpl last = branchList.get(branchList.size() - 1);
        int newIndex = last.getPrimaryIndex() + 1;
        GroupeItemImpl internalGroupeItem = new GroupeItemImpl(this, contexte, mask, parent);
        int[] array = internalGroupeItem.getSecondaryIndex();
        new Change(2, array);
        this.translate(internalGroupeItem, newIndex);
        this.internalGroupeItemMap.put(internalGroupeItem.getTermCode(), internalGroupeItem);
        this.checkVentilationNameEligible(parent);
    }

    void parentChanged(Contexte contexte) {
        GroupeItemImpl currentGroupeItem = this.getInternalGroupeItem(contexte);
        GroupeItemImpl oldParent = currentGroupeItem.getParent();
        GroupeItemImpl newParent = this.getParent(contexte);
        int newIndex = -1;
        for (int i = newParent.getPrimaryIndex() + 1; i < this.multiList.getPrimarySize(); ++i) {
            GroupeItemImpl igi = this.getInternalGroupeItemByIndex(i);
            if (igi.descendsFrom(newParent)) continue;
            newIndex = i;
            break;
        }
        currentGroupeItem.setParent(newParent);
        if (newIndex == -1) {
            newIndex = this.multiList.getPrimarySize() - 1;
        } else if (currentGroupeItem.getPrimaryIndex() < newIndex) {
            --newIndex;
        }
        List<GroupeItemImpl> list = this.getBranchList(currentGroupeItem);
        if (newIndex != currentGroupeItem.getPrimaryIndex()) {
            if (newIndex < currentGroupeItem.getPrimaryIndex()) {
                for (int i = 0; i < list.size(); ++i) {
                    GroupeItemImpl branchItem = list.get(i);
                    this.translate(branchItem, newIndex);
                    ++newIndex;
                }
            } else {
                for (int i = list.size() - 1; i >= 0; --i) {
                    GroupeItemImpl branchItem = list.get(i);
                    this.translate(branchItem, newIndex);
                    --newIndex;
                }
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                GroupeItemImpl branchItem = list.get(i);
                new Change(3, branchItem.getSecondaryIndex());
            }
        }
        this.checkVentilationNameEligible(oldParent);
        this.checkVentilationNameEligible(newParent);
    }

    void contexteRemoved(Contexte contexte) {
        GroupeItemImpl internalGroupeItem = this.getInternalGroupeItem(contexte);
        GroupeItemImpl oldParent = internalGroupeItem.getParent();
        this.removeInternalGroupeItem(internalGroupeItem);
        this.checkVentilationNameEligible(oldParent);
    }

    void grilleRemoved(Grille grille) {
        GroupeItemImpl internalGroupeItem = this.getInternalGroupeItem(grille);
        this.removeInternalGroupeItem(internalGroupeItem);
    }

    void libelleChanged(Term term) {
        GroupeItemImpl currentGroupeItem = this.getInternalGroupeItem(term);
        String s = AtlasUtils.toLibelleString(term, this.workingLang);
        currentGroupeItem.setLibelle(s);
        this.fireChange(currentGroupeItem);
    }

    void colorChanged(Object attributesHolder) {
        GroupeItemImpl currentGroupeItem = null;
        if (attributesHolder instanceof Contexte) {
            currentGroupeItem = this.getInternalGroupeItem((Contexte)attributesHolder);
        } else if (attributesHolder instanceof Grille) {
            currentGroupeItem = this.getInternalGroupeItem((Grille)attributesHolder);
        }
        if (currentGroupeItem == null) {
            return;
        }
        currentGroupeItem.setColor(AtlasAttributes.getColor((Term)attributesHolder));
        this.fireChange(currentGroupeItem);
    }

    void activeChanged(Contexte contexte) {
        short type = contexte.getTermType();
        GroupeItemImpl internalGroupeItem = this.getInternalGroupeItem(contexte);
        boolean active = contexte.isActive();
        int mask = 0;
        if (type == 4) {
            mask = listModelMaskByType[4] | listModelMaskByType[8];
        } else if (type == 3) {
            mask = listModelMaskByType[5];
        }
        if (mask > 0) {
            if (active) {
                int[] result1 = this.multiList.enable(internalGroupeItem, mask);
                new Change(2, result1);
            } else {
                int[] result1 = this.multiList.disable(internalGroupeItem, mask);
                new Change(1, result1);
            }
        }
        internalGroupeItem.setActive(active);
        this.fireChange(internalGroupeItem);
    }

    void fireChange(GroupeItemImpl internalGroupeItem) {
        int[] array = internalGroupeItem.getSecondaryIndex();
        new Change(3, array);
    }

    void childIndexChanged(Contexte contexte) {
        GroupeItemImpl currentGroupeItem = this.getInternalGroupeItem(contexte);
        GroupeItemImpl currentParent = this.getParent(contexte);
        MultiListItem replacedGroupeItem = null;
        int newChildIndex = contexte.getChildIndex();
        int p = -1;
        for (int i = currentParent.getPrimaryIndex() + 1; i < this.multiList.getPrimarySize(); ++i) {
            GroupeItemImpl igi = this.getInternalGroupeItemByIndex(i);
            if (!igi.getParent().equals(currentParent) || ++p != newChildIndex) continue;
            replacedGroupeItem = igi;
            break;
        }
        int replaceIndex = replacedGroupeItem.getPrimaryIndex();
        List<GroupeItemImpl> list = this.getBranchList(currentGroupeItem);
        if (replaceIndex < currentGroupeItem.getPrimaryIndex()) {
            for (int i = 0; i < list.size(); ++i) {
                GroupeItemImpl branchItem = list.get(i);
                this.translate(branchItem, replaceIndex);
                ++replaceIndex;
            }
        } else {
            replaceIndex = replaceIndex + this.getBranchList((GroupeItemImpl)replacedGroupeItem).size() - 1;
            for (int i = list.size() - 1; i >= 0; --i) {
                GroupeItemImpl branchItem = list.get(i);
                this.translate(branchItem, replaceIndex);
                --replaceIndex;
            }
        }
    }

    void translate(GroupeItemImpl internalGroupeItem, int newIndex) {
        int[] olds = internalGroupeItem.getSecondaryIndex();
        this.multiList.translate(internalGroupeItem, newIndex);
        int[] news = internalGroupeItem.getSecondaryIndex();
        new Change(4, olds, news);
    }

    List<GroupeItemImpl> getBranchList(GroupeItemImpl parent) {
        GroupeItemImpl igi;
        ArrayList<GroupeItemImpl> branchList = new ArrayList<GroupeItemImpl>();
        branchList.add(parent);
        for (int i = parent.getPrimaryIndex() + 1; i < this.multiList.getPrimarySize() && (igi = this.getInternalGroupeItemByIndex(i)).descendsFrom(parent); ++i) {
            branchList.add(igi);
        }
        return branchList;
    }

    void checkVentilationNameEligible(GroupeItemImpl internalGroupeItem) {
        short termeType = internalGroupeItem.getTermType();
        if (termeType == 4 || termeType == 6) {
            return;
        }
        int eligibletype = internalGroupeItem.getTermType() == 4 ? 6 : 7;
        int primaryIndex = internalGroupeItem.getPrimaryIndex();
        boolean ventilationNameEligible = true;
        if (primaryIndex == this.multiList.getPrimarySize() - 1) {
            ventilationNameEligible = false;
        } else {
            GroupeItemImpl next = this.getInternalGroupeItemByIndex(primaryIndex + 1);
            ventilationNameEligible = next.descendsFrom(internalGroupeItem);
        }
        int currentEligibleIndex = internalGroupeItem.getSecondaryIndex(listModelIndexByType[eligibletype]);
        if (ventilationNameEligible && currentEligibleIndex == -1) {
            int[] result = this.multiList.enable(internalGroupeItem, listModelMaskByType[eligibletype]);
            new Change(2, result);
        } else if (!ventilationNameEligible && currentEligibleIndex != -1) {
            int[] result = this.multiList.disable(internalGroupeItem, listModelMaskByType[eligibletype]);
            new Change(1, result);
        }
    }

    void checkNotEmptyChange(GroupeItemImpl internalGroupeItem, short changeType) {
        short termeType = internalGroupeItem.getTermType();
        int emptymask = 0;
        switch (termeType) {
            case 4: {
                emptymask = GroupeItemManagerImpl.getFamilleNotEmptyMask();
                break;
            }
            case 6: {
                emptymask = GroupeItemManagerImpl.getSansfamilleNotEmptyMask();
                break;
            }
            case 3: {
                emptymask = GroupeItemManagerImpl.getInGrilleContexteNotEmptyMask();
                break;
            }
            case 2: {
                emptymask = GroupeItemManagerImpl.getGrilleNotEmptyMask();
            }
        }
        switch (changeType) {
            case 1: {
                if (internalGroupeItem.getGroupeModel().getSize() != 0) break;
                int idx_emptyall = internalGroupeItem.getSecondaryIndex(listModelIndexByType[0]);
                if (idx_emptyall < 0) {
                    throw new IllegalStateException("baIndex : L'index est \u00e9gal \u00e0 -1");
                }
                int[] result = this.multiList.disable(internalGroupeItem, emptymask);
                new Change(1, result);
                break;
            }
            case 2: {
                int idx_emptyall = internalGroupeItem.getSecondaryIndex(listModelIndexByType[0]);
                if (idx_emptyall != -1) break;
                int[] result = this.multiList.enable(internalGroupeItem, emptymask);
                new Change(2, result);
            }
        }
    }

    private GroupeItemImpl getInternalGroupeItemByIndex(int i) {
        return (GroupeItemImpl)this.multiList.getItemPrimaryList().get(i);
    }

    static int getInitialMask(Grille grille) {
        int mask = listModelMaskByType[9];
        ContexteList contexteList = grille.getFirstLevelContexteList();
        int contexteCount = contexteList.getContexteCount();
        if (contexteCount > 0) {
            mask |= listModelMaskByType[7];
            boolean notempty = false;
            for (int i = 0; i < contexteCount; ++i) {
                Contexte child = contexteList.getContexte(i);
                if (child.isActive()) {
                    notempty = true;
                    break;
                }
                if (!notempty) continue;
                mask |= GroupeItemManagerImpl.getGrilleNotEmptyMask();
            }
        }
        return mask;
    }

    static int getInGrilleContexteInitialMask(Contexte contexte) {
        ContexteList contexteList;
        int contexteCount;
        int mask = 0;
        if (contexte.isActive()) {
            mask |= listModelMaskByType[5];
        }
        if ((contexteCount = (contexteList = contexte.getChildren()).getContexteCount()) > 0) {
            mask |= listModelMaskByType[7];
            boolean notempty = false;
            for (int i = 0; i < contexteCount; ++i) {
                Contexte child = contexteList.getContexte(i);
                if (!child.isActive()) continue;
                notempty = true;
                break;
            }
            if (notempty) {
                mask |= GroupeItemManagerImpl.getInGrilleContexteNotEmptyMask();
            }
        }
        return mask;
    }

    static int getSansfamilleInitialMask(Contexte contexte) {
        int mask = 0;
        mask |= listModelMaskByType[8];
        Descripteurs descripteurs = contexte.getAtlas().getDescripteurs();
        if (descripteurs.getInFamilleDescripteurList(contexte).getDescripteurCount() > 0) {
            mask |= GroupeItemManagerImpl.getSansfamilleNotEmptyMask();
        }
        return mask;
    }

    static int getFamilleInitialMask(Contexte contexte) {
        Descripteurs descripteurs;
        int mask = listModelMaskByType[6];
        if (contexte.isActive()) {
            mask |= listModelMaskByType[4];
            mask |= listModelMaskByType[8];
        }
        if ((descripteurs = contexte.getAtlas().getDescripteurs()).getInFamilleDescripteurList(contexte).getDescripteurCount() > 0) {
            mask |= GroupeItemManagerImpl.getFamilleNotEmptyMask();
        }
        return mask;
    }

    static int getGrilleNotEmptyMask() {
        int mask = listModelMaskByType[0];
        return mask |= listModelMaskByType[3];
    }

    static int getInGrilleContexteNotEmptyMask() {
        int mask = listModelMaskByType[0];
        return mask |= listModelMaskByType[3];
    }

    static int getSansfamilleNotEmptyMask() {
        int mask = listModelMaskByType[2];
        return mask |= listModelMaskByType[0];
    }

    static int getFamilleNotEmptyMask() {
        int mask = listModelMaskByType[2];
        mask |= listModelMaskByType[1];
        return mask |= listModelMaskByType[0];
    }

    static {
        GroupeItemManagerImpl.listModelIndexByType[0] = 0;
        GroupeItemManagerImpl.listModelIndexByType[1] = 1;
        GroupeItemManagerImpl.listModelIndexByType[2] = 2;
        GroupeItemManagerImpl.listModelIndexByType[3] = 3;
        GroupeItemManagerImpl.listModelIndexByType[4] = 4;
        GroupeItemManagerImpl.listModelIndexByType[5] = 5;
        GroupeItemManagerImpl.listModelIndexByType[6] = 6;
        GroupeItemManagerImpl.listModelIndexByType[7] = 7;
        GroupeItemManagerImpl.listModelIndexByType[8] = 8;
        GroupeItemManagerImpl.listModelIndexByType[9] = 9;
        listModelMaskByType = new int[10];
        GroupeItemManagerImpl.listModelMaskByType[0] = 1;
        GroupeItemManagerImpl.listModelMaskByType[1] = 2;
        GroupeItemManagerImpl.listModelMaskByType[2] = 4;
        GroupeItemManagerImpl.listModelMaskByType[3] = 8;
        GroupeItemManagerImpl.listModelMaskByType[4] = 16;
        GroupeItemManagerImpl.listModelMaskByType[5] = 32;
        GroupeItemManagerImpl.listModelMaskByType[6] = 64;
        GroupeItemManagerImpl.listModelMaskByType[7] = 128;
        GroupeItemManagerImpl.listModelMaskByType[8] = 256;
        GroupeItemManagerImpl.listModelMaskByType[9] = 512;
    }

    private class GroupeItemListModel
    extends AbstractComboBoxModel {
        private int secondaryIndex;

        private GroupeItemListModel(short type) {
            this.secondaryIndex = listModelIndexByType[type];
        }

        @Override
        public Object getElementAt(int index) {
            return GroupeItemManagerImpl.this.multiList.getItemSecondaryList(this.secondaryIndex).get(index);
        }

        @Override
        public int getSize() {
            return GroupeItemManagerImpl.this.multiList.getSecondarySize(this.secondaryIndex);
        }

        void commitChange(short type, int index, int index2) {
            switch (type) {
                case 1: {
                    this.fireObjectRemoved(index);
                    break;
                }
                case 2: {
                    this.fireObjectAdded(index);
                    break;
                }
                case 3: {
                    this.fireObjectChanged(index);
                    break;
                }
                case 4: {
                    this.fireIndexChanged(index, index2);
                }
            }
        }
    }

    private class Change {
        private final short type;
        private final int[] indexArray;
        private int[] indexArray2;

        private Change(short type, int[] indexArray) {
            this.type = type;
            this.indexArray = indexArray;
            this.commitChange();
        }

        private Change(short type, int[] indexArray, int[] indexArray2) {
            this.type = type;
            this.indexArray = indexArray;
            this.indexArray2 = indexArray2;
            this.commitChange();
        }

        private void commitChange() {
            for (int i = 0; i < this.indexArray.length; ++i) {
                int index = this.indexArray[i];
                if (index == -1) continue;
                GroupeItemListModel listModel = GroupeItemManagerImpl.this.listModels[i];
                int index2 = this.indexArray2 != null ? this.indexArray2[i] : -1;
                listModel.commitChange(this.type, index, index2);
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            switch (this.type) {
                case 1: {
                    buf.append("Object removed");
                    break;
                }
                case 2: {
                    buf.append("Object added");
                    break;
                }
                case 3: {
                    buf.append("Object changed");
                    break;
                }
                case 4: {
                    buf.append("Object translated");
                }
            }
            return buf.toString();
        }
    }
}

