/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.impl;

import net.desmodo.atlas.Term;

class TermCoder {
    private Term[] terms = new Term[128];
    private int size = 0;

    TermCoder() {
    }

    int getNewCode() {
        int newcode = this.size++;
        this.checkSize();
        this.terms[newcode] = null;
        return newcode;
    }

    void setTerm(int code, Term term) {
        if (code < 0 || code >= this.size) {
            throw new IllegalArgumentException("Missing code: " + code);
        }
        if (term != null && code != term.getCode()) {
            throw new IllegalArgumentException("Not matching code: " + code);
        }
        this.terms[code] = term;
    }

    Term getTerm(int code) {
        if (code < 0 || code >= this.size) {
            return null;
        }
        return this.terms[code];
    }

    private synchronized void checkSize() {
        if (this.size >= this.terms.length) {
            Term[] nv = new Term[this.terms.length * 3 / 2 + 1];
            System.arraycopy(this.terms, 0, nv, 0, this.terms.length);
            this.terms = nv;
        }
    }
}

