/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas;

import java.text.ParseException;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.Iddesc;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.Grille;
import net.mapeadores.util.net.UUIDURI;

public final class AtlasURI {
    private AtlasURI() {
    }

    public static Term parseURI(Atlas atlas, String uriString) {
        try {
            UUIDURI uri = UUIDURI.parse((String)uriString);
            return AtlasURI.parse(atlas, uri);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static Term parse(Atlas atlas, UUIDURI uri) {
        String scheme = uri.getScheme();
        if (scheme.equals("special")) {
            return AtlasURI.getSpecial(atlas, uri);
        }
        if (scheme.equals("grille")) {
            return AtlasURI.getGrille(atlas, uri);
        }
        if (scheme.equals("contexte")) {
            return AtlasURI.getContexte(atlas, uri);
        }
        if (scheme.equals("famille")) {
            return AtlasURI.getFamille(atlas, uri);
        }
        if (scheme.equals("descripteur")) {
            return AtlasURI.getDescripteur(atlas, uri);
        }
        if (scheme.equals("titre")) {
            return AtlasURI.getTitre(atlas, uri);
        }
        return null;
    }

    public static String toURIString(Term term) {
        if (term == null) {
            return "special:null";
        }
        switch (term.getTermType()) {
            case 1: {
                return AtlasURI.descripteurToURIString((Descripteur)term);
            }
            case 2: {
                return AtlasURI.grilleToURIString((Grille)term);
            }
            case 3: {
                return AtlasURI.ingrilleContexteToURIString((Contexte)term);
            }
            case 4: {
                return AtlasURI.familleToURIString((Contexte)term);
            }
            case 8: {
                return "titre:atlas";
            }
            case 7: {
                return "special:familles";
            }
            case 5: {
                return "special:horsgrille";
            }
            case 6: {
                return "special:sansfamille";
            }
        }
        throw new IllegalStateException("unknown termType :" + term.getTermType());
    }

    public static String[] toURITokens(Term term) {
        if (term == null) {
            return AtlasURI.toArray("special", "null");
        }
        switch (term.getTermType()) {
            case 1: {
                return AtlasURI.descripteurToURITokens((Descripteur)term);
            }
            case 2: {
                return AtlasURI.grilleToURITokens((Grille)term);
            }
            case 3: {
                return AtlasURI.ingrilleContexteToURITokens((Contexte)term);
            }
            case 4: {
                return AtlasURI.familleToURITokens((Contexte)term);
            }
            case 8: {
                return AtlasURI.toArray("titre", "atlas");
            }
            case 7: {
                return AtlasURI.toArray("special", "familles");
            }
            case 5: {
                return AtlasURI.toArray("special", "horsgrille");
            }
            case 6: {
                return AtlasURI.toArray("special", "sansfamille");
            }
        }
        throw new IllegalStateException("unknown termType: " + term.getTermType());
    }

    private static String descripteurToURIString(Descripteur descripteur) {
        return UUIDURI.toString((String)"descripteur", (String)descripteur.getIddesc().toString());
    }

    private static String[] descripteurToURITokens(Descripteur descripteur) {
        return AtlasURI.toArray("descripteur", descripteur.getIddesc().toString());
    }

    private static String grilleToURIString(Grille grille) {
        String grilleName = grille.getGrilleName();
        return UUIDURI.toString((String)"grille", (String)grilleName);
    }

    private static String[] grilleToURITokens(Grille grille) {
        String grilleName = grille.getGrilleName();
        return AtlasURI.toArray("grille", grilleName);
    }

    private static String familleToURIString(Contexte contexte) {
        return UUIDURI.toString((String)"famille", (String)contexte.getIdctxt());
    }

    private static String[] familleToURITokens(Contexte contexte) {
        return AtlasURI.toArray("famille", contexte.getIdctxt());
    }

    private static String ingrilleContexteToURIString(Contexte contexte) {
        Grille grille = contexte.getGrille();
        String grilleName = grille.getGrilleName();
        return UUIDURI.toString((String)"contexte", (String)grilleName, (String)contexte.getIdctxt());
    }

    private static String[] ingrilleContexteToURITokens(Contexte contexte) {
        Grille grille = contexte.getGrille();
        String grilleName = grille.getGrilleName();
        String[] result = new String[]{"contexte", grilleName, contexte.getIdctxt()};
        return result;
    }

    private static Term getSpecial(Atlas atlas, UUIDURI uri) {
        if (uri.getIdPartCount() != 1) {
            return null;
        }
        String value = uri.getIdPart(0);
        if (value.equals("sansfamille")) {
            return atlas.getStructure().getSpecialContexte((short)6);
        }
        if (value.equals("horsgrille")) {
            return atlas.getStructure().getSpecialContexte((short)5);
        }
        if (value.equals("familles")) {
            return atlas.getStructure().getGrilleDesFamilles();
        }
        return null;
    }

    private static Term getTitre(Atlas atlas, UUIDURI uri) {
        if (uri.getIdPartCount() != 1) {
            return null;
        }
        String value = uri.getIdPart(0);
        if (value.equals("atlas")) {
            return atlas.getAtlasMetadata().getTitre();
        }
        return null;
    }

    private static Grille getGrille(Atlas atlas, UUIDURI uri) {
        if (uri.getIdPartCount() != 1) {
            return null;
        }
        String grilleName = uri.getIdPart(0);
        if (uri.isAbsolute()) {
            throw new IllegalStateException(" pas encore impl\u00e9ment\u00e9");
        }
        return atlas.getStructure().getGrille(grilleName);
    }

    static Contexte getContexte(Atlas atlas, UUIDURI uri) {
        if (uri.getIdPartCount() != 2) {
            return null;
        }
        String grilleName = uri.getIdPart(0);
        String idctxt = uri.getIdPart(1);
        if (uri.isAbsolute()) {
            throw new IllegalStateException(" pas encore impl\u00e9ment\u00e9");
        }
        Grille grille = atlas.getStructure().getGrille(grilleName);
        if (grille == null) {
            return null;
        }
        return grille.getContexteByIdctxt(idctxt);
    }

    private static Contexte getFamille(Atlas atlas, UUIDURI uri) {
        if (uri.isAbsolute()) {
            throw new IllegalStateException(" pas encore impl\u00e9ment\u00e9");
        }
        if (uri.getIdPartCount() != 1) {
            return null;
        }
        String idctxt = uri.getIdPart(0);
        return atlas.getStructure().getGrilleDesFamilles().getContexteByIdctxt(idctxt);
    }

    private static Descripteur getDescripteur(Atlas atlas, UUIDURI uri) {
        if (uri.isAbsolute()) {
            throw new IllegalStateException(" pas encore impl\u00e9ment\u00e9");
        }
        if (uri.getIdPartCount() != 1) {
            return null;
        }
        String iddescString = uri.getIdPart(0);
        Iddesc iddesc = Iddesc.parse(iddescString);
        return atlas.getDescripteurs().getDescripteurByIddesc(iddesc);
    }

    private static String[] toArray(String s1, String s2) {
        String[] result = new String[]{s1, s2};
        return result;
    }
}

