/* UtilLib - Copyright (c) 2007-2015 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.mapeadores.util.instruction;


/**
 *
 * @author Vincent Calame
 */
public interface Argument {

    /**
     * N'est jamais nul ou de longueur nulle.
     */
    public String getKey();

    /**
     * Peut être soit nul ou de longueur non nulle
     */
    public String getValue();

    /**
     * Remplace la valeur nulle par une chaine vide.
     *
     * @return
     */
    public default String getNotNullValue() {
        String value = getValue();
        if (value == null) {
            return "";
        } else {
            return value;
        }
    }

}
