/* ScrutariDataExport - Java implementation of ScrutariDataExport API
 * http://www.scrutari.net/dokuwiki/scrutaridata:exportapi
 *
 * Copyright (c) 2010-2025 Vincent Calame - Exemole
 * Licensed under MIT
 * (http://en.wikipedia.org/wiki/MIT_License)
 */


package net.scrutari.dataexport;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import net.scrutari.dataexport.xml.XmlWriter;


/**
 *
 * @author Vincent Calame
 */
public class ScrutariInfoUtils {

    private ScrutariInfoUtils() {
    }

    public static void writeScrutariInfo(Appendable appendable, int indentLength, boolean includeXMLDeclaration, LocalDate date, String[] urlArray) {
        XmlWriter xmlWriter = new XmlWriter(appendable, indentLength, includeXMLDeclaration, false);
        xmlWriter.openTag("info");
        xmlWriter.addSimpleElement("date", DateTimeFormatter.ISO_LOCAL_DATE.format(date));
        int length = urlArray.length;
        for (int i = 0; i < length; i++) {
            xmlWriter.addSimpleElement("scrutaridata-url", urlArray[i]);
        }
        xmlWriter.closeTag("info");
    }

}
