/* FichothequeLib_Tools - Copyright (c) 2024-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.importation.thesaurus;

import net.fichotheque.importation.ParentChange;
import net.fichotheque.importation.ThesaurusImport;
import net.fichotheque.tools.importation.ImportationUtils;
import net.fichotheque.tools.importation.TiesImportBuilder;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.text.LabelChange;
import net.mapeadores.util.text.LabelChangeBuilder;
import net.mapeadores.util.text.LabelUtils;
import net.fichotheque.importation.TiesImport;


/**
 *
 * @author Vincent Calame
 */
public class EditMotcleImportBuilder {

    private final int motcleId;
    private String newIdalpha = null;
    private String newStatus = null;
    private ParentChange parentChange = null;
    protected LabelChangeBuilder labelChangeBuilder;
    protected AttributeChangeBuilder attributeChangeBuilder;
    protected TiesImportBuilder tiesImportBuilder;

    public EditMotcleImportBuilder(int motcleId) {
        this.motcleId = motcleId;
    }

    public EditMotcleImportBuilder setNewIdalpha(String newIdalpha) {
        this.newIdalpha = newIdalpha;
        return this;
    }

    public EditMotcleImportBuilder setNewStatus(String newStatus) {
        this.newStatus = newStatus;
        return this;
    }

    public EditMotcleImportBuilder setParent(ParentChange parentChange) {
        this.parentChange = parentChange;
        return this;
    }

    public LabelChangeBuilder getLabelChangeBuilder() {
        if (labelChangeBuilder == null) {
            labelChangeBuilder = new LabelChangeBuilder();
        }
        return labelChangeBuilder;
    }

    public AttributeChangeBuilder getAttributeChangeBuilder() {
        if (attributeChangeBuilder == null) {
            attributeChangeBuilder = new AttributeChangeBuilder();
        }
        return attributeChangeBuilder;
    }

    public TiesImportBuilder getTiesImportBuilder() {
        if (tiesImportBuilder == null) {
            tiesImportBuilder = new TiesImportBuilder();
        }
        return tiesImportBuilder;
    }

    private LabelChange getLabelChange() {
        if (labelChangeBuilder == null) {
            return LabelUtils.EMPTY_LABELCHANGE;
        } else {
            return labelChangeBuilder.toLabelChange();
        }
    }

    private AttributeChange getAttributeChange() {
        if (attributeChangeBuilder == null) {
            return AttributeUtils.EMPTY_ATTRIBUTECHANGE;
        } else {
            return attributeChangeBuilder.toAttributeChange();
        }
    }

    private TiesImport getTiesImport() {
        if (tiesImportBuilder == null) {
            return ImportationUtils.EMPTY_TIESIMPORT;
        } else {
            return tiesImportBuilder.toTiesImport();
        }
    }

    public ThesaurusImport.EditMotcleImport toEditMotcleImport() {
        return new InternalEditMotcleImport(motcleId, newIdalpha, newStatus, parentChange, getLabelChange(), getAttributeChange(), getTiesImport());
    }

    public static EditMotcleImportBuilder init(int motcleId) {
        return new EditMotcleImportBuilder(motcleId);
    }


    private static class InternalEditMotcleImport implements ThesaurusImport.EditMotcleImport {

        private final int motcleId;
        private final String newIdalpha;
        private final String newStatus;
        private final ParentChange parentChange;
        private final LabelChange labelChange;
        private final AttributeChange attributeChange;
        private final TiesImport tiesImport;

        private InternalEditMotcleImport(int motcleId, String newIdalpha, String newStatus, ParentChange parentChange, LabelChange labelChange, AttributeChange attributeChange, TiesImport tiesImport) {
            this.motcleId = motcleId;
            this.newIdalpha = newIdalpha;
            this.newStatus = newStatus;
            this.parentChange = parentChange;
            this.labelChange = labelChange;
            this.attributeChange = attributeChange;
            this.tiesImport = tiesImport;
        }

        @Override
        public int getMotcleId() {
            return motcleId;
        }

        @Override
        public String getNewIdalpha() {
            return newIdalpha;
        }

        @Override
        public ParentChange getParentChange() {
            return parentChange;
        }

        @Override
        public String getNewStatus() {
            return newStatus;
        }

        @Override
        public LabelChange getLabelChange() {
            return labelChange;
        }

        @Override
        public AttributeChange getAttributeChange() {
            return attributeChange;
        }

        @Override
        public TiesImport getTiesImport() {
            return tiesImport;
        }


    }

}
