/* FichothequeLib_Tools - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.format.catalogs;

import net.fichotheque.corpus.SubfieldValue;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.FicheItemFormatter;
import net.fichotheque.format.formatters.SubfieldFormatter;
import net.fichotheque.tools.format.FormatterEngineUtils;


/**
 *
 * @author Vincent Calame
 */
public final class SubfieldFormatterCatalog {

    public final static SubfieldFormatter STRING_VALUE = (subfieldValue, formatSource) -> {
        Object obj = subfieldValue.getValue();
        if (!(obj instanceof String)) {
            return "#ERR: " + obj.getClass().getName();
        }
        return (String) obj;
    };
    public final static SubfieldFormatter STRING_VALUE_UP = (subfieldValue, formatSource) -> {
        Object obj = subfieldValue.getValue();
        if (!(obj instanceof String)) {
            return "#ERR: " + obj.getClass().getName();
        }
        return FormatterEngineUtils.toUppercase((String) obj, formatSource);
    };

    private SubfieldFormatterCatalog() {

    }


    public static class FicheItemSubfield implements SubfieldFormatter {

        private final FicheItemFormatter ficheItemFormatter;

        public FicheItemSubfield(FicheItemFormatter ficheItemFormatter) {
            this.ficheItemFormatter = ficheItemFormatter;
        }

        @Override
        public String formatSubfield(SubfieldValue subfieldValue, FormatSource formatSource) {
            Object obj = subfieldValue.getValue();
            if (!(obj instanceof FicheItem)) {
                return "#ERR: " + obj.getClass().getName();
            }
            return ficheItemFormatter.formatFicheItem((FicheItem) obj, formatSource);
        }

    }

}
