/* FichothequeLib_Tools - Copyright (c) 2021-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.dom.revisions;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fichotheque.junction.JunctionRevision;
import net.fichotheque.junction.Tie;
import net.fichotheque.utils.JunctionUtils;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;


/**
 *
 * @author Vincent Calame
 */
public class JunctionRevisionDOMReader {

    private final RootConsumer rootConsumer = new RootConsumer();

    public JunctionRevision readJunctionRevision(Element element) {
        JunctionRevision junctionRevision = new JunctionRevision();
        DOMUtils.readChildren(element, rootConsumer);
        rootConsumer.flush(junctionRevision);
        return junctionRevision;
    }


    private class RootConsumer implements Consumer<Element> {

        private final Map<String, Tie> tieMap = new LinkedHashMap<String, Tie>();
        private final List<Element> attrTempList = new ArrayList<Element>();

        private RootConsumer() {
        }

        private void clear() {
            tieMap.clear();
            attrTempList.clear();
        }

        private void flush(JunctionRevision junctionRevision) {
            for (Tie tie : tieMap.values()) {
                junctionRevision.addTie(tie);
            }
            clear();
        }

        @Override
        public void accept(Element element) {
            switch (element.getTagName()) {
                case "tie":
                case "lien":
                    String mode = element.getAttribute("mode");
                    int weight = getWeight(element);
                    int position1 = getPosition(element, "position1");
                    int position2 = getPosition(element, "position2");
                    Tie tie = JunctionUtils.toTie(mode, weight, position1, position2);
                    tieMap.put(mode, tie);
                    break;

                case "attr":
                    attrTempList.add(element);
                    break;
            }
        }

        private int getWeight(Element element) {
            int weight = 1;
            String weightString = element.getAttribute("weight");
            if (weightString.isEmpty()) {
                weightString = element.getAttribute("poids");
            }
            if (weightString.length() > 0) {
                try {
                    weight = Integer.parseInt(weightString);
                    if (weight < 1) {
                        weight = 1;
                    }
                } catch (NumberFormatException nfe) {
                }
            }
            return weight;
        }

        private int getPosition(Element element, String attributeName) {
            int position = 0;
            String posString = element.getAttribute(attributeName);
            if (posString.length() > 0) {
                try {
                    position = Integer.parseInt(posString);
                    if (position < 0) {
                        position = 0;
                    }
                } catch (NumberFormatException nfe) {
                }
            }
            return position;
        }

    }

}
