<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:draw="urn:oasis:names:tc:opendocument:xmlns:drawing:1.0"  xmlns:svg="urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0">


<!--
********************************************************************************
* ficheitem-
********************************************************************************
-->

    <xsl:template match="*" mode="ficheitem-Block">
        <text:p text:style-name="FicheFieldItem">
            <xsl:apply-templates select="."/>
        </text:p>
    </xsl:template>

    <xsl:template match="*" mode="ficheitem-Listitem">
        <text:list-item>
            <text:p text:style-name="FicheFieldLi">
                <xsl:apply-templates select="."/>
            </text:p>
        </text:list-item>
    </xsl:template>

    <xsl:template match="*" mode="ficheitem-Inline">
        <xsl:call-template name="ficheitem-addSeparator"/>
        <xsl:apply-templates select="."/>
    </xsl:template>
    
    <xsl:template name="ficheitem-addSeparator">
        <xsl:if test="position() &gt; 1">
            <xsl:text>, </xsl:text>
        </xsl:if>
    </xsl:template>


<!--
********************************************************************************
* Default
********************************************************************************
-->

    <xsl:template match="item">
        <xsl:value-of select="."/>
    </xsl:template>

    <xsl:template match="person|personne">
        <xsl:apply-templates select="." mode="ficheitem-person-Name"/>
        <xsl:apply-templates select="organism"/>
    </xsl:template>
    
    <xsl:template match="person[nonlatin]|personne[nonlatin]">
        <xsl:if test="surname or forename">
            <xsl:apply-templates select="." mode="ficheitem-person-Name"/>
            <xsl:text> / </xsl:text>
        </xsl:if>
        <xsl:value-of select="nonlatin"/>
        <xsl:apply-templates select="organism"/>
    </xsl:template>

    <xsl:template match="organism">
        <xsl:text> (</xsl:text>
        <xsl:value-of select="."/>
        <xsl:text>)</xsl:text>
    </xsl:template>

    <xsl:template match="language|langue">
        <xsl:choose>
            <xsl:when test="label[@xml:lang = $WORKINGLANG]">
                <xsl:value-of select="label[@xml:lang = $WORKINGLANG]"/>
            </xsl:when>
            <xsl:when test="label">
                <xsl:value-of select="label[1]"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="@lang"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="country|pays">
        <xsl:choose>
            <xsl:when test="label[@xml:lang = $WORKINGLANG]">
                <xsl:value-of select="label[@xml:lang = $WORKINGLANG]"/>
            </xsl:when>
            <xsl:when test="label">
                <xsl:value-of select="label[1]"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="@country"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="image[@base-url]">
        <draw:frame draw:name="{generate-id(.)}" draw:style-name="FbeImage" text:anchor-type="as-char" draw:z-index="0" svg:width="2cm" svg:height="3cm">
            <draw:image xlink:href="{@base-url}{@src}" xlink:type="simple" xlink:show="embed" xlink:actuate="onLoad"/>
        </draw:frame>
    </xsl:template>

    <xsl:template match="image">
        <xsl:value-of select="@src"/>
    </xsl:template>

    <xsl:template match="para">
        <xsl:apply-templates select="." mode="ficheblock-ParagraphContent"/>
    </xsl:template>

    <xsl:template match="date|datation">
        <xsl:choose>
            <xsl:when test="label[@xml:lang = $WORKINGLANG]">
                <xsl:value-of select="label[@xml:lang = $WORKINGLANG]"/>
            </xsl:when>
            <xsl:when test="label">
                <xsl:value-of select="label[1]"/>
            </xsl:when>
            <xsl:otherwise></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="amount|montant">
        <xsl:choose>
            <xsl:when test="label[@xml:lang = $WORKINGLANG]">
                <xsl:value-of select="label[@xml:lang = $WORKINGLANG]"/>
            </xsl:when>
            <xsl:when test="label">
                <xsl:value-of select="label[1]"/>
            </xsl:when>
            <xsl:otherwise></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="number|nombre">
        <xsl:choose>
            <xsl:when test="label[@xml:lang = $WORKINGLANG]">
                <xsl:value-of select="label[@xml:lang = $WORKINGLANG]"/>
            </xsl:when>
            <xsl:when test="label">
                <xsl:value-of select="label[1]"/>
            </xsl:when>
            <xsl:otherwise></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="geopoint">
        <xsl:apply-templates select="latitude"/>
        <xsl:text> </xsl:text>
        <xsl:apply-templates select="longitude"/>
    </xsl:template>

    <xsl:template match="latitude">
        <xsl:choose>
            <xsl:when test="label[@xml:lang = $WORKINGLANG]">
                <xsl:value-of select="label[@xml:lang = $WORKINGLANG]"/>
            </xsl:when>
            <xsl:when test="label">
                <xsl:value-of select="label[1]"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="../@lat"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="longitude">
        <xsl:choose>
            <xsl:when test="label[@xml:lang = $WORKINGLANG]">
                <xsl:value-of select="label[@xml:lang = $WORKINGLANG]"/>
            </xsl:when>
            <xsl:when test="label">
                <xsl:value-of select="label[1]"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="../@lon"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="email|courriel">
        <text:a xlink:type="simple" xlink:href="mailto:{.}">
            <xsl:value-of select="."/>
        </text:a>
    </xsl:template>
    
    <xsl:template match="link[@base-url]">
        <text:a xlink:type="simple" xlink:href="{@base-url}{@href}">
            <xsl:value-of select="title"/>
        </text:a>
        <xsl:if test="string-length(comment) &gt; 0">
            <xsl:text> (</xsl:text>
            <xsl:value-of select="comment"/>
            <xsl:text>)</xsl:text>
        </xsl:if>
    </xsl:template>

    <xsl:template match="link">
        <text:a xlink:type="simple" xlink:href="{@href}">
            <xsl:value-of select="title"/>
        </text:a>
        <xsl:if test="string-length(comment) &gt; 0">
            <xsl:text> (</xsl:text>
            <xsl:value-of select="comment"/>
            <xsl:text>)</xsl:text>
        </xsl:if>
    </xsl:template>


 <!--
********************************************************************************
* ficheitem-person-
********************************************************************************
-->

    <xsl:template match="person[surname/@surname-first]|personne[surname/@surname-first]" mode="ficheitem-person-Name">
        <xsl:value-of select="surname"/>
        <xsl:if test="forename">
            <xsl:text> </xsl:text>
            <xsl:value-of select="forename"/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="person[not(surname)]|personne[not(surname)]" mode="ficheitem-person-Name">
        <xsl:value-of select="forename"/>
    </xsl:template>

    <xsl:template match="person|personne" mode="ficheitem-person-Name">
        <xsl:if test="forename">
            <xsl:value-of select="forename"/>
            <xsl:text> </xsl:text>
        </xsl:if>
        <xsl:value-of select="surname"/>
    </xsl:template>
    
</xsl:stylesheet>
