/* BdfServer_Multi - Copyright (c) 2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.multi.subscribe;

import fr.exemole.bdfserver.multi.api.Multi;
import net.mapeadores.util.request.RequestMap;


/**
 *
 * @author Vincent Calame
 */
public class SubscribeParameters {

    private final SubscribeManager subscribeManager;
    private final Multi multi;
    private final RequestMap requestMap;
    private final String rootUrl;

    public SubscribeParameters(SubscribeManager subscribeManager, Multi multi, RequestMap requestMap, String rootUrl) {
        this.subscribeManager = subscribeManager;
        this.multi = multi;
        this.requestMap = requestMap;
        this.rootUrl = rootUrl;
    }

    public SubscribeManager subscribeManager() {
        return subscribeManager;
    }

    public Multi multi() {
        return multi;
    }

    public RequestMap requestMap() {
        return requestMap;
    }

    public String rootUrl() {
        return rootUrl;
    }

}
