/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text.lexie;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LocalisationLexieFilters;
import net.mapeadores.util.text.SubstringPosition;
import net.mapeadores.util.text.collation.CollationUnit;
import net.mapeadores.util.text.collation.map.SortedCollatedKeyMap;
import net.mapeadores.util.text.lexie.LexieDistribution;
import net.mapeadores.util.text.lexie.LexieFilter;
import net.mapeadores.util.text.lexie.LexieParseHandler;
import net.mapeadores.util.text.lexie.LexieParser;
import net.mapeadores.util.text.lexie.LexieSource;
import net.mapeadores.util.text.lexie.Occurrence;
import net.mapeadores.util.text.lexie.ParsedLexieSource;
import net.mapeadores.util.text.lexie.TextLexieUnit;

public class LexieDistributionBuilder {
    private final SortedCollatedKeyMap<InternalLexieUnit> collatedKeyMap;
    private final LexieFilter lexieFilter;
    private final Map<String, ParsedLexieSource> lexieSourceMap = new LinkedHashMap<String, ParsedLexieSource>();

    public LexieDistributionBuilder(Lang lang) {
        this.collatedKeyMap = new SortedCollatedKeyMap(lang.toLocale());
        this.lexieFilter = LocalisationLexieFilters.getLexieFilter(lang);
    }

    public void addLexieSource(LexieSource lexieSource) {
        InternalParsedLexieSource ipls = new InternalParsedLexieSource(lexieSource);
        this.lexieSourceMap.put(lexieSource.getSourceId(), ipls);
        InternalLexieParseHandler lexieParseHandler = new InternalLexieParseHandler(ipls);
        LexieParser.parse(lexieSource.getSourceText(), lexieParseHandler);
    }

    public LexieDistribution toLexieDistribution() {
        TextLexieUnit[] textLexieUnitArray = this.collatedKeyMap.values().toArray(new TextLexieUnit[this.collatedKeyMap.size()]);
        return new InternalLexieDistribution(textLexieUnitArray, this.lexieSourceMap);
    }

    private static class InternalParsedLexieSource
    implements ParsedLexieSource {
        private final LexieSource lexieSource;
        private final List<Occurrence> occurrenceList = new ArrayList<Occurrence>();

        private InternalParsedLexieSource(LexieSource lexieSource) {
            this.lexieSource = lexieSource;
        }

        @Override
        public LexieSource getLexieSource() {
            return this.lexieSource;
        }

        @Override
        public int getOccurrenceCount() {
            return this.occurrenceList.size();
        }

        @Override
        public Occurrence getOccurrence(int index) {
            return this.occurrenceList.get(index);
        }

        private void addOccurrence(Occurrence occurrence) {
            this.occurrenceList.add(occurrence);
        }
    }

    private class InternalLexieParseHandler
    implements LexieParseHandler {
        private final InternalParsedLexieSource parsedLexieSource;

        private InternalLexieParseHandler(InternalParsedLexieSource parsedLexieSource) {
            this.parsedLexieSource = parsedLexieSource;
        }

        @Override
        public void flushLexie(String lexie, int lexieStartIndex) {
            if (LexieDistributionBuilder.this.lexieFilter != null && !LexieDistributionBuilder.this.lexieFilter.acceptLexie(lexie)) {
                return;
            }
            String collatedLexie = CollationUnit.collate(lexie, LexieDistributionBuilder.this.collatedKeyMap.getCollator());
            InternalLexieUnit lexieUnit = (InternalLexieUnit)LexieDistributionBuilder.this.collatedKeyMap.getValueByCollatedKey(collatedLexie);
            if (lexieUnit == null) {
                lexieUnit = new InternalLexieUnit(collatedLexie, LexieDistributionBuilder.this.collatedKeyMap.size() + 1);
                LexieDistributionBuilder.this.collatedKeyMap.putValueByCollatedKey(collatedLexie, lexieUnit);
            }
            SubstringPosition substringPosition = new SubstringPosition(lexieStartIndex, lexie.length());
            InternalOccurrence implOccurence = new InternalOccurrence(lexieUnit, this.parsedLexieSource, substringPosition);
            this.parsedLexieSource.addOccurrence(implOccurence);
            lexieUnit.addOccurence(implOccurence);
            lexieUnit.checkCanonical(lexie);
        }

        @Override
        public void checkSpecialChar(char carac) {
        }
    }

    private static class InternalLexieDistribution
    implements LexieDistribution {
        private final TextLexieUnit[] textLexieUnitArray;
        private final ParsedLexieSource[] lexieSourceArray;
        private final Map<String, ParsedLexieSource> lexieSourceMap;

        private InternalLexieDistribution(TextLexieUnit[] textLexieUnitArray, Map<String, ParsedLexieSource> lexieSourceMap) {
            this.textLexieUnitArray = textLexieUnitArray;
            this.lexieSourceArray = lexieSourceMap.values().toArray(new ParsedLexieSource[lexieSourceMap.size()]);
            this.lexieSourceMap = lexieSourceMap;
        }

        @Override
        public int getLexieUnitCount() {
            return this.textLexieUnitArray.length;
        }

        @Override
        public TextLexieUnit getLexieUnit(int index) {
            return this.textLexieUnitArray[index];
        }

        @Override
        public int getParserLexieSourceCount() {
            return this.lexieSourceArray.length;
        }

        @Override
        public ParsedLexieSource getParsedLexieSourceByIndex(int index) {
            return this.lexieSourceArray[index];
        }

        @Override
        public ParsedLexieSource getParsedLexieSourceBySourceId(String sourceId) {
            return this.lexieSourceMap.get(sourceId);
        }
    }

    private static class InternalLexieUnit
    implements TextLexieUnit {
        private final String collatedLexie;
        private final List<Occurrence> occurrenceList = new ArrayList<Occurrence>();
        private final String lexieId;
        private String canonicalLexie;

        private InternalLexieUnit(String collatedLexie, int id) {
            this.collatedLexie = collatedLexie;
            this.lexieId = String.valueOf(id);
        }

        @Override
        public String getCollatedLexie() {
            return this.collatedLexie;
        }

        @Override
        public String getCanonicalLexie() {
            return this.canonicalLexie;
        }

        @Override
        public String getLexieId() {
            return this.lexieId;
        }

        @Override
        public int getOccurrenceCount() {
            return this.occurrenceList.size();
        }

        @Override
        public Occurrence getOccurrence(int index) {
            return this.occurrenceList.get(index);
        }

        private void addOccurence(InternalOccurrence occurence) {
            InternalOccurrence last;
            int occurencePosition = 1;
            if (this.occurrenceList.size() > 0 && (last = (InternalOccurrence)this.occurrenceList.get(this.occurrenceList.size() - 1)).getParsedLexieSource().equals(occurence.getParsedLexieSource())) {
                occurencePosition = last.getOccurrencePosition() + 1;
            }
            occurence.setOccurencePosition(occurencePosition);
            this.occurrenceList.add(occurence);
        }

        private void checkCanonical(String lexie) {
            if (this.canonicalLexie == null) {
                this.canonicalLexie = lexie;
            } else if (lexie.length() < this.canonicalLexie.length()) {
                this.canonicalLexie = lexie;
            }
        }
    }

    private static class InternalOccurrence
    implements Occurrence {
        private final InternalLexieUnit implLexieUnit;
        private final SubstringPosition substringPosition;
        private final InternalParsedLexieSource implParsedLexieSource;
        private int occurrencePosition;

        private InternalOccurrence(InternalLexieUnit implLexieUnit, InternalParsedLexieSource implParsedLexieSource, SubstringPosition substringPosition) {
            this.implLexieUnit = implLexieUnit;
            this.substringPosition = substringPosition;
            this.implParsedLexieSource = implParsedLexieSource;
        }

        @Override
        public TextLexieUnit getLexieUnit() {
            return this.implLexieUnit;
        }

        @Override
        public SubstringPosition getSubstringPosition() {
            return this.substringPosition;
        }

        @Override
        public ParsedLexieSource getParsedLexieSource() {
            return this.implParsedLexieSource;
        }

        @Override
        public int getOccurrencePosition() {
            return this.occurrencePosition;
        }

        private void setOccurencePosition(int occurencePosition) {
            this.occurrencePosition = occurencePosition;
        }
    }
}

