/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.servlets.handlers;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.time.Instant;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.request.JsonType;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.request.RequestUtils;
import net.mapeadores.util.servlets.ResponseHandler;

public class JsonResponseHandler
implements ResponseHandler,
JsonType {
    public static final String ALL_ORIGIN = "*";
    private final JsonProducer jsonProducer;
    private Instant lastModified = ResponseHandler.LASTMODIFIED_NOCACHE;
    private final short jsonType;
    private final String callbackFunctionName;
    private String accessControlOrigin;
    private boolean allowCredentials = false;

    public JsonResponseHandler(@Nullable JsonProducer jsonProducer, short jsonType, @Nullable String callbackFunctionName) {
        this.jsonProducer = jsonProducer;
        switch (jsonType) {
            case 2: {
                this.jsonType = (short)2;
                if (callbackFunctionName == null) {
                    this.callbackFunctionName = "callback";
                    break;
                }
                this.callbackFunctionName = callbackFunctionName;
                break;
            }
            case 3: {
                this.callbackFunctionName = callbackFunctionName;
                this.jsonType = (short)3;
                break;
            }
            default: {
                this.callbackFunctionName = callbackFunctionName;
                this.jsonType = callbackFunctionName != null ? (short)2 : (short)1;
            }
        }
    }

    @Override
    public Instant getLastModified() {
        return this.lastModified;
    }

    public JsonResponseHandler lastModified(Instant lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public JsonResponseHandler accessControl(String origin) {
        this.accessControlOrigin = origin;
        return this;
    }

    public JsonResponseHandler allowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
        return this;
    }

    public JsonResponseHandler giveAccess(RequestMap requestMap) {
        Object sourceObject = requestMap.getSourceObject();
        if (sourceObject != null && sourceObject instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)sourceObject;
            String origin = httpRequest.getHeader("origin");
            this.accessControl(origin);
        } else {
            this.accessControl(ALL_ORIGIN);
        }
        this.allowCredentials(true);
        return this;
    }

    @Override
    public void handleResponse(HttpServletResponse response) throws IOException {
        if (this.accessControlOrigin != null) {
            response.setHeader("Access-Control-Allow-Origin", this.accessControlOrigin);
            if (!this.accessControlOrigin.equals(ALL_ORIGIN)) {
                response.setHeader("Vary", "Origin");
            }
        }
        if (this.allowCredentials) {
            response.setHeader("Access-Control-Allow-Credentials", "true");
        }
        response.setContentType(RequestUtils.jsonTypeToContentType(this.jsonType));
        ServletOutputStream outputStream = response.getOutputStream();
        try (BufferedWriter bufWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, "UTF-8"));){
            boolean callback;
            boolean embedded = this.jsonType == 3;
            boolean bl = callback = this.callbackFunctionName != null;
            if (embedded) {
                bufWriter.write("<textarea>");
            }
            if (callback) {
                bufWriter.write(this.callbackFunctionName);
                bufWriter.write("(");
            }
            if (this.jsonProducer != null) {
                this.jsonProducer.writeJson(bufWriter);
            } else {
                this.writeNull(bufWriter);
            }
            if (callback) {
                bufWriter.write(");");
            }
            if (embedded) {
                bufWriter.write("</textarea>");
            }
        }
    }

    private void writeNull(Writer writer) throws IOException {
        JSONWriter jw = new JSONWriter(writer);
        jw.object();
        jw.key("noOutput").value(true);
        jw.endObject();
    }

    public static JsonResponseHandler init(@Nullable JsonProducer jsonProducer, short jsonType, @Nullable String callbackFunctionName) {
        return new JsonResponseHandler(jsonProducer, jsonType, callbackFunctionName);
    }

    public static JsonResponseHandler build(@Nullable JsonProducer jsonProducer, RequestMap requestMap) {
        short jsonType = RequestUtils.getJsonType(requestMap);
        String callback = requestMap.getParameter("callback");
        return new JsonResponseHandler(jsonProducer, jsonType, callback);
    }
}

