/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.localisation;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.ListLangContext;

public class ListLangContextBuilder {
    private final List<ListLangContext.Unit> unitList = new ArrayList<ListLangContext.Unit>();
    private final Set<Lang> existingLang = new HashSet<Lang>();

    public void addLang(Lang lang) {
        if (lang == null) {
            throw new NullPointerException("lang is null");
        }
        if (!this.existingLang.contains(lang)) {
            this.existingLang.add(lang);
            this.unitList.add(new InternalUnit(lang, lang.toLocale()));
        }
    }

    public void addLang(Lang lang, Locale formatLocale) {
        if (lang == null) {
            throw new NullPointerException("lang is null");
        }
        if (formatLocale == null) {
            throw new NullPointerException("formatLocale is null");
        }
        if (!this.existingLang.contains(lang)) {
            this.existingLang.add(lang);
            this.unitList.add(new InternalUnit(lang, formatLocale));
        }
    }

    public void addLangs(Langs langs) {
        for (Lang lang : langs) {
            this.addLang(lang);
        }
    }

    public ListLangContext toListLangContext() {
        int size = this.unitList.size();
        if (size == 0) {
            throw new IllegalStateException("ListLangContext is empty");
        }
        ListLangContext.Unit[] unitArray = this.unitList.toArray(new ListLangContext.Unit[size]);
        return new InternalListLangContext(unitArray);
    }

    public static ListLangContext build(Lang lang) {
        if (lang == null) {
            throw new NullPointerException("lang is null");
        }
        ListLangContextBuilder builder = new ListLangContextBuilder();
        builder.addLang(lang);
        return builder.toListLangContext();
    }

    public static ListLangContext build(Lang[] langArray) {
        int length = langArray.length;
        if (length == 0) {
            throw new IllegalArgumentException("langIntegerArray.length == 0");
        }
        ListLangContextBuilder builder = new ListLangContextBuilder();
        for (int i = 0; i < length; ++i) {
            builder.addLang(langArray[i]);
        }
        return builder.toListLangContext();
    }

    public static ListLangContext build(Langs langs) {
        if (langs.isEmpty()) {
            throw new IllegalArgumentException("langList.getLangCount() == 0");
        }
        ListLangContextBuilder builder = new ListLangContextBuilder();
        builder.addLangs(langs);
        return builder.toListLangContext();
    }

    private static class InternalUnit
    implements ListLangContext.Unit {
        private final Lang lang;
        private final Locale formatLocale;

        private InternalUnit(Lang lang, Locale formatLocale) {
            this.lang = lang;
            this.formatLocale = formatLocale;
        }

        @Override
        public Lang getLang() {
            return this.lang;
        }

        @Override
        public Locale getFormatLocale() {
            return this.formatLocale;
        }
    }

    private static class InternalListLangContext
    extends AbstractList<ListLangContext.Unit>
    implements ListLangContext {
        private final ListLangContext.Unit[] unitArray;

        private InternalListLangContext(ListLangContext.Unit[] unitArray) {
            this.unitArray = unitArray;
        }

        @Override
        public int size() {
            return this.unitArray.length;
        }

        @Override
        public ListLangContext.Unit get(int index) {
            return this.unitArray[index];
        }
    }
}

