/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.format;

import java.time.format.FormatStyle;

public interface FormatConstants {
    public static final String SEVERE_SOURCE = "severe.format.source";
    public static final String SEVERE_PATTERN = "severe.format.pattern";
    public static final String SEVERE_INSTRUCTION = "severe.format.instruction";
    public static final String WARNING_INSTRUCTION = "warning.format.instruction";
    public static final String SEVERE_SYNTAX = "severe.format.syntax";
    public static final String WARNING_SYNTAX = "warning.format.syntax";
    public static final String WARNING_FICHOTHEQUE = "warning.format.fichotheque";
    public static final int MAX_POSITION = 999999999;
    public static final int UNDEFINED = -9;
    public static final String INTEGER_CAST = "integer";
    public static final String DECIMAL_CAST = "decimal";
    public static final String DATE_CAST = "date";
    public static final String MONEY_CAST = "money";
    public static final String PERCENTAGE_CAST = "percentage";
    public static final String JSON_CAST = "json";
    public static final String CALCUL_PARAMKEY = "calc";
    public static final String CAST_PARAMKEY = "cast";
    public static final String MAXLENGTH_PARAMKEY = "maxlength";
    public static final String FIXEDLENGTH_PARAMKEY = "fixedlength";
    public static final String FIXEDCHAR_PARAMKEY = "fixedchar";
    public static final String FIXEDEMPTY_PARAMKEY = "fixedempty";
    public static final String DEFAULTVALUE_PARAMKEY = "defval";
    public static final String GLOBALSELECT_PARAMKEY = "globalselect";
    public static final String JSONARRAY_PARAMKEY = "jsonarray";
    public static final String LIMIT_PARAMKEY = "limit";
    public static final String EMPTYTONULL_PARAMKEY = "null";
    public static final String POSITION_PARAMKEY = "pos";
    public static final String POSTTRANSFORM_PARAMKEY = "posttransform";
    public static final String PREFIX_PARAMKEY = "prefix";
    public static final String SEPARATOR_PARAMKEY = "sep";
    public static final String SUFFIX_PARAMKEY = "suffix";
    public static final String SUM_PARAMKEY = "sum";
    public static final String COLUMNSUM_PARAMKEY = "columnsum";
    public static final String UNIQUETEST_PARAMKEY = "unique";
    public static final String FORMULA_PARAMKEY = "formula";
    public static final String DATESTYLE_PARAMKEY = "datestyle";
    public static final String SHORT_DATESTYLE = "short";
    public static final String MEDIUM_DATESTYLE = "medium";
    public static final String LONG_DATESTYLE = "long";
    public static final String FULL_DATESTYLE = "full";
    public static final String LAST_PARAMVALUE = "last";
    public static final String FORCE_AMOUNTSUBUNIT = "force";

    public static String checkCastType(String castType) {
        switch (castType) {
            case "integer": 
            case "int": {
                return INTEGER_CAST;
            }
            case "decimal": 
            case "double": 
            case "float": {
                return DECIMAL_CAST;
            }
            case "date": {
                return DATE_CAST;
            }
            case "money": 
            case "amount": {
                return MONEY_CAST;
            }
            case "percentage": {
                return PERCENTAGE_CAST;
            }
            case "json": {
                return JSON_CAST;
            }
        }
        throw new IllegalArgumentException("Unknown cast type : " + castType);
    }

    public static String checkDateStyle(String dateStyle) {
        switch (dateStyle) {
            case "short": {
                return SHORT_DATESTYLE;
            }
            case "medium": {
                return MEDIUM_DATESTYLE;
            }
            case "long": {
                return LONG_DATESTYLE;
            }
            case "full": {
                return FULL_DATESTYLE;
            }
        }
        throw new IllegalArgumentException("Unknown date style : " + dateStyle);
    }

    public static FormatStyle getMatchingFormatStyle(String dateStyle) {
        switch (dateStyle) {
            case "short": {
                return FormatStyle.SHORT;
            }
            case "medium": {
                return FormatStyle.MEDIUM;
            }
            case "long": {
                return FormatStyle.LONG;
            }
            case "full": {
                return FormatStyle.FULL;
            }
        }
        return null;
    }
}

