/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.io.odtable;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.mapeadores.opendocument.io.SheetNameChecker;
import net.mapeadores.opendocument.io.SheetWriter;
import net.mapeadores.opendocument.io.odtable.OdTableDef;
import net.mapeadores.opendocument.io.odtable.OdsXMLPart;
import net.mapeadores.opendocument.io.odtable.StyleManagerBuilder;

public class SheetHandler {
    private final SheetWriter sheetWriter;
    private final Map<String, String> checkedNameMap = new LinkedHashMap<String, String>();

    public SheetHandler(SheetWriter sheetWriter) {
        this.sheetWriter = sheetWriter;
    }

    public void addSupplementary(StyleManagerBuilder styleManagerBuilder, SheetNameChecker sheetNameChecker) {
        for (OdTableDef odTableDef : this.sheetWriter.getTableDefList()) {
            String originalName = odTableDef.getTableName();
            String checkedName = sheetNameChecker.checkName(originalName);
            styleManagerBuilder.putTableDef(checkedName, odTableDef);
            this.checkedNameMap.put(checkedName, originalName);
        }
    }

    public void writeSupplementary(OdsXMLPart xmlPart) throws IOException {
        for (Map.Entry<String, String> entry : this.checkedNameMap.entrySet()) {
            this.sheetWriter.writeTable(xmlPart, entry.getValue(), entry.getKey());
        }
    }
}

