/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers.corpus;

import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.corpus.EditCorpusImportBuilder;
import net.fichotheque.tools.importation.corpus.EditFicheImportBuilder;
import net.fichotheque.tools.importation.parsers.ImportationParseContext;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.parsers.corpus.CorpusColumns;
import net.fichotheque.tools.importation.parsers.corpus.EditRowParser;
import net.fichotheque.tools.parsers.FicheParser;

class ChangeRowParser
extends EditRowParser {
    ChangeRowParser(EditCorpusImportBuilder editCorpusImportBuilder, ParseResultBuilder parseResultBuilder, FicheParser ficheParser, CorpusColumns corpusColumns, ImportationParseContext parseContext) {
        super(editCorpusImportBuilder, parseResultBuilder, ficheParser, corpusColumns, parseContext);
    }

    @Override
    public void parseRow(int rowNumber, Row row) {
        int idIndex = this.corpusColumns.getIdIndex();
        if (row.getColumnCount() <= idIndex) {
            this.parseResultBuilder.missingIdColumn(rowNumber);
            return;
        }
        String idString = row.getColumnValue(idIndex).trim();
        FicheMeta ficheMeta = null;
        try {
            int id = Integer.parseInt(idString);
            ficheMeta = this.corpus.getFicheMetaById(id);
            if (ficheMeta == null) {
                this.parseResultBuilder.unknownId(rowNumber, idString);
            }
        }
        catch (NumberFormatException nfe) {
            this.parseResultBuilder.notIntegerId(rowNumber, idString);
        }
        if (ficheMeta == null) {
            return;
        }
        EditFicheImportBuilder ficheImportBuilder = this.editCorpusImportBuilder.getEditFicheImportBuilder(ficheMeta);
        this.populate(ficheImportBuilder, row);
        this.setCreationDate(ficheImportBuilder, rowNumber, row);
    }

    static ChangeRowParser newInstance(String[] fieldArray, EditCorpusImportBuilder corpusImportBuilder, ParseResultBuilder parseResultBuilder, FicheParser ficheParser, ImportationParseContext parseContext) {
        CorpusColumns corpusColumns = CorpusColumns.parse(fieldArray, corpusImportBuilder, parseResultBuilder);
        if (corpusColumns.getIdIndex() == -1) {
            parseResultBuilder.missingColumn("id");
            return null;
        }
        return new ChangeRowParser(corpusImportBuilder, parseResultBuilder, ficheParser, corpusColumns, parseContext);
    }
}

