/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.dom;

import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeConstants;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.importation.dom.ImportationDomUtils;
import net.fichotheque.tools.importation.dom.TiesImportDOMReader;
import net.fichotheque.tools.importation.thesaurus.EditMotcleImportBuilder;
import net.fichotheque.tools.importation.thesaurus.EditThesaurusImportBuilder;
import net.fichotheque.tools.importation.thesaurus.MergeThesaurusImportBuilder;
import net.fichotheque.tools.importation.thesaurus.MoveThesaurusImportBuilder;
import net.fichotheque.tools.importation.thesaurus.RemoveThesaurusImportBuilder;
import net.fichotheque.tools.importation.thesaurus.ThesaurusImportBuilder;
import net.fichotheque.utils.ParentChangeUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class ThesaurusImportDOMReader {
    private final ThesaurusImportBuilder thesaurusImportBuilder;
    private final Thesaurus thesaurus;
    private final Fichotheque fichotheque;

    public ThesaurusImportDOMReader(ThesaurusImportBuilder thesaurusImportBuilder) {
        this.thesaurusImportBuilder = thesaurusImportBuilder;
        this.thesaurus = thesaurusImportBuilder.getThesaurus();
        this.fichotheque = this.thesaurus.getFichotheque();
    }

    public ThesaurusImportDOMReader read(Element element) {
        Consumer<Element> elementConsumer;
        String type;
        switch (type = this.thesaurusImportBuilder.getType()) {
            case "edit": {
                elementConsumer = new EditConsumer((EditThesaurusImportBuilder)this.thesaurusImportBuilder);
                break;
            }
            case "merge": {
                elementConsumer = new MergeConsumer((MergeThesaurusImportBuilder)this.thesaurusImportBuilder);
                break;
            }
            case "move": {
                elementConsumer = new MoveConsumer((MoveThesaurusImportBuilder)this.thesaurusImportBuilder);
                break;
            }
            case "remove": {
                elementConsumer = new RemoveConsumer((RemoveThesaurusImportBuilder)this.thesaurusImportBuilder);
                break;
            }
            default: {
                throw new SwitchException("Unknown type: " + type);
            }
        }
        DOMUtils.readChildren(element, elementConsumer);
        return this;
    }

    public static ThesaurusImportDOMReader init(ThesaurusImportBuilder thesaurusImportBuilder) {
        return new ThesaurusImportDOMReader(thesaurusImportBuilder);
    }

    private class EditConsumer
    implements Consumer<Element> {
        private final EditThesaurusImportBuilder editThesaurusImportBuilder;

        private EditConsumer(EditThesaurusImportBuilder editThesaurusImportBuilder) {
            this.editThesaurusImportBuilder = editThesaurusImportBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "motcleimport": {
                    String idString = element.getAttribute("id");
                    String idalpha = this.getIdalpha(element);
                    if (idString.isEmpty()) {
                        Motcle motcle;
                        boolean isChange = false;
                        if (idalpha != null && (motcle = ThesaurusImportDOMReader.this.thesaurus.getMotcleByIdalpha(idalpha)) != null) {
                            this.readChange(motcle, element, null);
                            isChange = true;
                        }
                        if (isChange) break;
                        this.readCreation(-1, idalpha, element);
                        break;
                    }
                    try {
                        int id = Integer.parseInt(idString);
                        Motcle motcle = ThesaurusImportDOMReader.this.thesaurus.getMotcleById(id);
                        if (motcle != null) {
                            this.readChange(motcle, element, idalpha);
                            break;
                        }
                        this.readCreation(id, idalpha, element);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }

        private String getIdalpha(Element element) {
            IdalphaConsumer idalphaConsumer = new IdalphaConsumer();
            DOMUtils.readChildren(element, idalphaConsumer);
            return idalphaConsumer.idalpha;
        }

        private void readChange(Motcle motcle, Element element, String newIdalpha) {
            EditMotcleImportBuilder builder = this.editThesaurusImportBuilder.getEditMotcleImportBuilder(motcle);
            if (newIdalpha != null) {
                builder.setNewIdalpha(newIdalpha);
            }
            DOMUtils.readChildren(element, new EditMotcleConsumer(builder));
        }

        private void readCreation(int newId, String idalpha, Element element) {
            EditMotcleImportBuilder builder = this.editThesaurusImportBuilder.getEditMotcleImportBuilder(newId, idalpha);
            DOMUtils.readChildren(element, new EditMotcleConsumer(builder));
        }
    }

    private class MergeConsumer
    implements Consumer<Element> {
        private final MergeThesaurusImportBuilder mergeThesaurusImportBuilder;

        private MergeConsumer(MergeThesaurusImportBuilder mergeThesaurusImportBuilder) {
            this.mergeThesaurusImportBuilder = mergeThesaurusImportBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "motcleimport": {
                    String idString = element.getAttribute("id");
                    String destinationString = element.getAttribute("destination");
                    try {
                        int id = Integer.parseInt(idString);
                        int destinationId = Integer.parseInt(destinationString);
                        Motcle motcle = ThesaurusImportDOMReader.this.thesaurus.getMotcleById(id);
                        Motcle destinationMotcle = ThesaurusImportDOMReader.this.thesaurusImportBuilder.getDestinationThesaurus().getMotcleById(destinationId);
                        if (motcle == null || destinationMotcle == null) break;
                        this.mergeThesaurusImportBuilder.add(motcle, destinationMotcle);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class MoveConsumer
    implements Consumer<Element> {
        private final MoveThesaurusImportBuilder moveThesaurusImportBuilder;

        private MoveConsumer(MoveThesaurusImportBuilder moveThesaurusImportBuilder) {
            this.moveThesaurusImportBuilder = moveThesaurusImportBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "motcleimport": {
                    String idString = element.getAttribute("id");
                    try {
                        int id = Integer.parseInt(idString);
                        Motcle motcle = ThesaurusImportDOMReader.this.thesaurus.getMotcleById(id);
                        if (motcle == null) break;
                        this.moveThesaurusImportBuilder.add(motcle);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class RemoveConsumer
    implements Consumer<Element> {
        private final RemoveThesaurusImportBuilder removeThesaurusImportBuilder;

        private RemoveConsumer(RemoveThesaurusImportBuilder removeThesaurusImportBuilder) {
            this.removeThesaurusImportBuilder = removeThesaurusImportBuilder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "motcleimport": {
                    String idString = element.getAttribute("id");
                    try {
                        int id = Integer.parseInt(idString);
                        Motcle motcle = ThesaurusImportDOMReader.this.thesaurus.getMotcleById(id);
                        if (motcle == null) break;
                        this.removeThesaurusImportBuilder.add(motcle);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class IdalphaConsumer
    implements Consumer<Element> {
        private String idalpha = null;

        private IdalphaConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "idalpha": {
                    CleanedString idalphaString = DOMUtils.contentToCleanedString(element);
                    if (idalphaString == null) break;
                    this.idalpha = idalphaString.toString();
                }
            }
        }
    }

    private class EditMotcleConsumer
    implements Consumer<Element> {
        private final EditMotcleImportBuilder builder;

        private EditMotcleConsumer(EditMotcleImportBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "attr": {
                    ImportationDomUtils.readAttrElement(element, this.builder.getAttributeChangeBuilder());
                    break;
                }
                case "label": 
                case "lib": {
                    ImportationDomUtils.readLabelElement(element, this.builder.getLabelChangeBuilder());
                    break;
                }
                case "idalpha": {
                    break;
                }
                case "parent": {
                    String idString = element.getAttribute("id");
                    if (idString.isEmpty()) {
                        String idalphaParent = element.getAttribute("idalpha");
                        if (idalphaParent.isEmpty()) {
                            this.builder.setParent(ParentChangeUtils.THESAURUS);
                            break;
                        }
                        this.builder.setParent(ParentChangeUtils.toIdalphaParentChange(idalphaParent));
                        break;
                    }
                    try {
                        int parentId = Integer.parseInt(idString);
                        this.builder.setParent(ParentChangeUtils.toIdParentChange(parentId));
                    }
                    catch (NumberFormatException parentId) {}
                    break;
                }
                case "status": {
                    String statusValue = DOMUtils.readSimpleElement(element);
                    try {
                        this.builder.setNewStatus(FichothequeConstants.checkMotcleStatus(statusValue));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
                case "ties": 
                case "liens": {
                    String type = element.getAttribute("type");
                    TiesImportDOMReader.init(ThesaurusImportDOMReader.this.fichotheque, this.builder.getTiesImportBuilder(), type).read(element);
                }
            }
        }
    }
}

