/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.corpus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.importation.CorpusImport;
import net.fichotheque.tools.importation.ImportationUtils;
import net.fichotheque.tools.importation.corpus.CorpusImportBuilder;
import net.fichotheque.tools.importation.corpus.EditFicheImportBuilder;

public class EditCorpusImportBuilder
extends CorpusImportBuilder {
    private final List<EditFicheImportBuilder> builderList = new ArrayList<EditFicheImportBuilder>();
    private final Map<Integer, EditFicheImportBuilder> ficheMap = new HashMap<Integer, EditFicheImportBuilder>();
    private final Map<Integer, EditFicheImportBuilder> builderMap = new HashMap<Integer, EditFicheImportBuilder>();

    public EditCorpusImportBuilder(Corpus corpus) {
        super(corpus, "edit");
    }

    public EditFicheImportBuilder getEditFicheImportBuilder(FicheMeta ficheMeta) {
        int ficheId = ficheMeta.getId();
        EditFicheImportBuilder builder = this.ficheMap.get(ficheId);
        if (builder == null) {
            builder = new EditFicheImportBuilder(ficheId);
            this.ficheMap.put(ficheId, builder);
            this.builderList.add(builder);
        }
        return builder;
    }

    public EditFicheImportBuilder getEditFicheImportBuilder(int newId) {
        EditFicheImportBuilder builder;
        if (newId > 0) {
            builder = this.builderMap.get(newId);
            if (builder == null) {
                builder = new EditFicheImportBuilder(newId);
                this.builderList.add(builder);
                this.builderMap.put(newId, builder);
            }
        } else {
            builder = new EditFicheImportBuilder(-1);
            this.builderList.add(builder);
        }
        return builder;
    }

    @Override
    protected List<CorpusImport.FicheImport> getFicheImportList() {
        ArrayList<CorpusImport.EditFicheImport> finalList = new ArrayList<CorpusImport.EditFicheImport>();
        for (EditFicheImportBuilder builder : this.builderList) {
            CorpusImport.EditFicheImport ficheImport = builder.toEditFicheImport();
            finalList.add(ficheImport);
        }
        return ImportationUtils.wrap(finalList.toArray(new CorpusImport.FicheImport[finalList.size()]));
    }

    public static EditCorpusImportBuilder init(Corpus corpus) {
        return new EditCorpusImportBuilder(corpus);
    }
}

