/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.parsers;

import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.ExtractionFormatter;
import net.fichotheque.format.formatters.FicheBlockFormatter;
import net.fichotheque.tools.format.ValuesParameters;
import net.fichotheque.tools.format.catalogs.FicheBlockFormatterCatalog;
import net.fichotheque.tools.format.patterndefs.DefaultPattern;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;

public final class FicheBlockFormatterParser {
    private FicheBlockFormatterParser() {
    }

    public static FicheBlockFormatter parse(String pattern, FormatContext formatContext, MessageHandler messageHandler) {
        if (pattern == null) {
            pattern = DefaultPattern.ficheBlock();
        }
        try {
            return FicheBlockFormatterParser.parse(pattern, formatContext);
        }
        catch (ErrorMessageException fe) {
            messageHandler.addMessage("severe.format.pattern", fe.getErrorMessage());
            return null;
        }
    }

    public static FicheBlockFormatter parse(String pattern, FormatContext formatContext) throws ErrorMessageException {
        Object[] partArray = FormatterUtils.parsePattern(new InternalInstructionResolver(formatContext), pattern);
        return new InternalFicheBlockFormatter(partArray);
    }

    private static class InternalInstructionResolver
    implements InstructionResolver {
        private final FormatContext formatContext;

        private InternalInstructionResolver(FormatContext formatContext) {
            this.formatContext = formatContext;
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            String key;
            Object formatter;
            InstructionResolver resolver = this.formatContext.getInstructionResolverProvider().getInstructionResolver(ExtractionFormatter.class);
            if (resolver != null && (formatter = resolver.resolve(instruction)) != null) {
                return formatter;
            }
            Argument arg1 = (Argument)instruction.get(0);
            switch (key = arg1.getKey()) {
                case "formsyntax": {
                    return FicheBlockFormatterCatalog.FORMSYNTAX;
                }
                case "text": {
                    return FicheBlockFormatterCatalog.TEXT;
                }
                case "values": {
                    return new FicheBlockFormatterCatalog.Values(ValuesParameters.fromInstruction(instruction));
                }
                case "xml": {
                    return this.formatContext.getFicheBlockFormatter("special:xml", instruction.toOptionMap(1));
                }
                case "transformation": 
                case "xslt": {
                    String name = arg1.getValue();
                    FicheBlockFormatter ficheBlockFormatter = this.formatContext.getFicheBlockFormatter(name, instruction.toOptionMap(1));
                    if (ficheBlockFormatter == null) {
                        throw new ErrorMessageException("_ error.unknown.template", name);
                    }
                    return ficheBlockFormatter;
                }
            }
            return null;
        }
    }

    private static class InternalFicheBlockFormatter
    implements FicheBlockFormatter {
        private final Object[] partArray;

        private InternalFicheBlockFormatter(Object[] partArray) {
            this.partArray = partArray;
        }

        @Override
        public String formatFicheBlocks(FicheBlocks ficheBlocks, FormatSource formatSource, SubsetKey defaultCorpusKey) {
            StringBuilder buf = new StringBuilder();
            for (Object obj : this.partArray) {
                if (obj instanceof String) {
                    buf.append((String)obj);
                    continue;
                }
                FicheBlockFormatter formatter = (FicheBlockFormatter)obj;
                buf.append(formatter.formatFicheBlocks(ficheBlocks, formatSource, defaultCorpusKey));
            }
            return buf.toString();
        }
    }
}

