/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.exportation.transformation;

import java.text.ParseException;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.exceptions.ShouldNotOccurException;

public final class TransformationKey {
    public static final String COMPILATION = "compilation";
    public static final String STATTHESAURUS = "statthesaurus";
    public static final String INVERSETHESAURUS = "inversethesaurus";
    public static final String SECTION = "section";
    public static final String FORMAT = "format";
    public static final String MEMENTO = "memento";
    public static final TransformationKey COMPILATION_INSTANCE = new TransformationKey("compilation");
    public static final TransformationKey STATTHESAURUS_INSTANCE = new TransformationKey("statthesaurus");
    public static final TransformationKey INVERSETHESAURUS_INSTANCE = new TransformationKey("inversethesaurus");
    public static final TransformationKey SECTION_INSTANCE = new TransformationKey("section");
    public static final TransformationKey FORMAT_INSTANCE = new TransformationKey("format");
    public static final TransformationKey MEMENTO_INSTANCE = new TransformationKey("memento");
    private final String key;
    private final boolean isCorpusTransformationKey;

    private TransformationKey(String key) {
        this.key = key;
        this.isCorpusTransformationKey = false;
    }

    private TransformationKey(String key, boolean isCorpusTransformationKey) {
        this.key = key;
        this.isCorpusTransformationKey = isCorpusTransformationKey;
    }

    public TransformationKey(SubsetKey corpusKey) {
        if (!corpusKey.isCorpusSubset()) {
            throw new IllegalArgumentException("corpusKey.isCorpusSubset() == false");
        }
        this.key = corpusKey.getKeyString();
        this.isCorpusTransformationKey = true;
    }

    public boolean isCorpusTransformationKey() {
        return this.isCorpusTransformationKey;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return this.key.equals(((TransformationKey)other).key);
    }

    public String getKeyString() {
        return this.key;
    }

    public String toString() {
        return this.key;
    }

    public SubsetKey toCorpusKey() {
        if (!this.isCorpusTransformationKey) {
            throw new IllegalStateException("transformationKey is not a corpus transformationKey");
        }
        try {
            return SubsetKey.parse(this.key);
        }
        catch (ParseException pe) {
            throw new ShouldNotOccurException(pe);
        }
    }

    public static TransformationKey parse(String s) throws ParseException {
        switch (s) {
            case "compilation": {
                return COMPILATION_INSTANCE;
            }
            case "statthesaurus": {
                return STATTHESAURUS_INSTANCE;
            }
            case "inversethesaurus": {
                return INVERSETHESAURUS_INSTANCE;
            }
            case "section": {
                return SECTION_INSTANCE;
            }
            case "format": {
                return FORMAT_INSTANCE;
            }
            case "memento": {
                return MEMENTO_INSTANCE;
            }
        }
        if (!s.startsWith("corpus_")) {
            throw new ParseException("!s.startsWith(\"corpus_\")", 0);
        }
        return new TransformationKey(s, true);
    }
}

