/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.fiche;

import java.io.Serializable;
import net.fichotheque.corpus.fiche.FicheItem;
import net.mapeadores.util.text.StringUtils;

public final class LinkItem
implements FicheItem,
Serializable {
    private static final long serialVersionUID = 3L;
    private String href = "";
    private String title = "";
    private String comment = "";

    public LinkItem(String href, String title, String comment) {
        if (href == null) {
            throw new IllegalArgumentException("href argument is null");
        }
        if (title == null) {
            throw new IllegalArgumentException("title argument is null");
        }
        if (comment == null) {
            throw new IllegalArgumentException("comment argument is null");
        }
        this.href = StringUtils.cleanString(href);
        this.title = StringUtils.cleanString(title);
        this.comment = StringUtils.cleanString(comment);
    }

    public String getHref() {
        return this.href;
    }

    public String getTitle() {
        return this.title;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean hasHrefOnly() {
        return this.title.length() == 0 && this.comment.length() == 0;
    }

    public String toString() {
        return "link: " + this.href;
    }

    public int hashCode() {
        return this.href.hashCode() + this.title.hashCode() + this.comment.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LinkItem)) {
            return false;
        }
        LinkItem other = (LinkItem)obj;
        return other.href.equals(this.href) && other.title.equals(this.title) && other.comment.equals(this.comment);
    }
}

