/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.api.exportation.transformation.SimpleTemplateFactory;
import fr.exemole.bdfserver.tools.exportation.transformation.BdfTransformationUtils;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.fichotheque.exportation.transformation.SimpleTemplate;
import net.fichotheque.extraction.def.ExtractionDef;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.exceptions.NestedTransformerException;

public class XsltSimpleTemplateFactory
implements SimpleTemplateFactory {
    private final BdfServer bdfServer;
    private final PathConfiguration pathConfiguration;
    private final Attributes attributes;
    private final ExtractionDef customExtractionDef;
    private final Templates templates;

    public XsltSimpleTemplateFactory(BdfServer bdfServer, PathConfiguration pathConfiguration, Attributes attributes, ExtractionDef customExtractionDef, Templates templates) {
        this.bdfServer = bdfServer;
        this.pathConfiguration = pathConfiguration;
        this.attributes = attributes;
        this.customExtractionDef = customExtractionDef;
        this.templates = templates;
    }

    @Override
    public SimpleTemplate newInstance() {
        Transformer transformer = BdfTransformationUtils.newTransformer(this.bdfServer, this.pathConfiguration, this.templates);
        return new XsltSimpleTemplate(this.attributes, this.customExtractionDef, transformer);
    }

    private static class XsltSimpleTemplate
    implements SimpleTemplate {
        private final Attributes attributes;
        private final ExtractionDef customExtractionDef;
        private final Transformer transformer;
        private final String mimeType;

        public XsltSimpleTemplate(Attributes attributes, ExtractionDef customExtractionDef, Transformer transformer) {
            this.attributes = attributes;
            this.customExtractionDef = customExtractionDef;
            this.transformer = transformer;
            String method = transformer.getOutputProperty("method");
            this.mimeType = method == null || method.equals("xml") ? "text/xml" : (method.equals("html") ? "text/html" : "text/plain");
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public ExtractionDef getCustomExtractionDef() {
            return this.customExtractionDef;
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public String getCharset() {
            String encoding = this.transformer.getOutputProperty("encoding");
            if (encoding == null) {
                return "UTF-8";
            }
            return encoding;
        }

        @Override
        public String transform(Source extractionSource, Map<String, Object> paramMap) {
            StringWriter stringWriter = new StringWriter();
            if (paramMap != null) {
                for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                    this.transformer.setParameter(entry.getKey(), entry.getValue());
                }
            }
            try {
                this.transformer.transform(extractionSource, new StreamResult(stringWriter));
            }
            catch (TransformerException te) {
                throw new NestedTransformerException(te);
            }
            return stringWriter.toString();
        }
    }
}

